/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.web.ere.rma;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class HtmlHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 8282337285146173527L;
    private static final Attributes.Name ERE_VERSION = new Attributes.Name("ERE-Version");
    private static final Attributes.Name COPYRIGHT_YEAR = new Attributes.Name("EWP-RMA-build-year");
    private static final Logger logger = Logger.getLogger(HtmlHttpServlet.class.getCanonicalName());
    private static final String FILE_PATH = "/opt/lwac/application/configuration.yaml";
    private static final Integer PRIVACY_NOTICE_TEXT_MAX_LENGTH = 300;
    private String version = "";
    private String ereVersion = "";
    private String copyrightYear = "";
    private String PRIVACY_NOTICE_DEFAULT;
    private String privacyNotice = this.PRIVACY_NOTICE_DEFAULT = "This system processes sensitive personal data. The misuse of such data may generate considerable harm to the data subjects. Be reminded of the confidentiality obligations you have when accessing this kind of data and the disciplinary consequences of improper handling.";

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        try (InputStream stream = servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");){
            if (stream != null) {
                Manifest manifest = new Manifest(stream);
                this.version = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                this.version = this.version != null ? this.version : "";
                this.ereVersion = manifest.getMainAttributes().getValue(ERE_VERSION);
                this.ereVersion = this.ereVersion != null ? this.ereVersion : "";
                this.copyrightYear = manifest.getMainAttributes().getValue(COPYRIGHT_YEAR);
                this.copyrightYear = this.copyrightYear != null ? this.copyrightYear : "2013";
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        String legalWarningMessage = this.getPrivacyNoticeMessage();
        this.privacyNotice = null != legalWarningMessage ? legalWarningMessage : this.privacyNotice;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        PrintWriter writer = resp.getWriter();
        writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        writer.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"styles.css\" />");
        writer.println("<link rel=\"shortcut icon\" type=\"image/vnd.microsoft.icon\"");
        writer.println("\thref=\"favicon.ico\" />");
        writer.println("<link rel=\"icon\" type=\"image/vnd.microsoft.icon\" href=\"favicon.ico\" />");
        writer.println("<title>RMA</title>");
        writer.println("</head>");
        writer.println("<body>");
        writer.println("\t<div class=\"page-body\">");
        writer.println("\t\t<div class=\"page-window\"");
        writer.println("\t\t\tstyle=\"overflow: hidden; height: 570px; width: 520px;\">");
        writer.println("\t\t\t<div style=\"margin: 10px;\">");
        writer.println("\t\t\t\t<div style=\"height: 86px; width: 96px; margin: 20px;\">");
        writer.println("\t\t\t\t\t<img src=\"img/logo-with-text.png\">");
        writer.println("\t\t\t\t</div>");
        writer.println("\t\t\t\t<div style=\"padding-top: 60px\">");
        writer.println("\t\t\t\t\t<img src=\"img/app_name.png\">");
        writer.println("\t\t\t\t</div>");
        writer.println("\t\t\t\t<div style=\"padding-top: 25px\">");
        writer.println("\t\t\t\t\t<div style=\"padding-top: 8px\">");
        writer.printf("              <a href=\"ewp-rma-%s.jar\">Download RMA application</a>", this.version).println();
        writer.println("\t\t\t\t\t</div>");
        writer.println("\t\t\t\t</div>");
        writer.println("\t\t\t\t<div style=\"padding-top: 12px\">");
        writer.println("\t\t\t\t\t<a href=\"examples.zip\">Download Examples</a>");
        writer.println("\t\t\t\t</div>");
        writer.printf("\t\t\t\t<div class=\"copyright\" style=\"width: 454px;text-align: justify;padding-top: 45px\">%s</div>", this.privacyNotice).println();
        writer.println("\t\t\t<div class=\"copyright\" style=\"width: 454px; padding-top: 14px\"><font color=\"red\">Requires Java Runtime Environment 11</font></div>");
        writer.printf("\t\t\t\t<div class=\"copyright\" style=\"width: 454px;padding-top: 8px\">Version: %s</div>", this.version).println();
        writer.printf("\t\t\t\t<div class=\"copyright\" style=\"width: 454px\">RMA: %s</div>", this.ereVersion).println();
        writer.printf("\t\t\t<div class=\"copyright\" style=\"width: 454px\">\u00a9 Ericsson Mobile Financial Services AB, 2012-%s, All Rights Reserved</div>", this.copyrightYear).println();
        writer.println("\t\t</div>");
        writer.println("\t</div>");
        writer.println("</body>");
        writer.println("</html>");
    }

    private String getPrivacyNoticeMessage() {
        String privacyNoticeMessage = null;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            Map rmaConfigMap = (Map)mapper.readValue(new File(FILE_PATH), Map.class);
            Map propertiesMap = (Map)rmaConfigMap.get("rma");
            if (null != propertiesMap && propertiesMap.containsKey("privacy_notice")) {
                privacyNoticeMessage = propertiesMap.get("privacy_notice").toString();
                Jsoup.clean((String)privacyNoticeMessage, (Safelist)Safelist.basic());
            }
            logger.info("privacy notice contents: " + privacyNoticeMessage);
            if (null != privacyNoticeMessage && privacyNoticeMessage.length() > PRIVACY_NOTICE_TEXT_MAX_LENGTH) {
                logger.warning("privacy notice contents length is greater than " + PRIVACY_NOTICE_TEXT_MAX_LENGTH + " characters so display content is truncated");
                privacyNoticeMessage = privacyNoticeMessage.substring(0, PRIVACY_NOTICE_TEXT_MAX_LENGTH);
            }
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
        }
        return privacyNoticeMessage;
    }
}

