/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.batchtransaction.v1_5.common;

import com.ericsson.em.m3if.batchtransaction.v1_0.common.BatchItemStatus;
import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.products.v1_0.common.ProductIdValue;
import com.ericsson.em.m3if.products.v1_0.common.ProductOfferingIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsAlias;
import com.ericsson.em.validators.IsBankDomain;
import com.ericsson.em.validators.IsDateString;
import com.ericsson.em.validators.IsEmail;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsLanguage;
import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.IsUsername;
import com.ericsson.em.validators.Length;
import iso.std.iso._20022.tech.xsd.PersonIdentificationType1Code;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/batchtransaction/v1_5/common", name="batchiteminformation", propOrder={"batchId", "externalId", "financialTransactionType", "financialTransactionId", "originalFinancialTransactionId", "transactionId", "lastUpdateDate", "status", "amount", "fromFri", "fromMessage", "senderFirstname", "senderSurname", "toFri", "toMessage", "receiverFirstname", "receiverSurname", "toDateOfBirth", "toIdentificationType", "toIdentification", "toMsisdn", "toEmail", "toUsername", "toExternalId", "toAlias", "toLanguageCode", "comment", "errorDescription", "accountHolderIdentity", "fromBankDomain", "toBankDomain", "additionalInformation", "toFsp", "productId", "productOfferingId"})
public class BatchItemInformation
implements Serializable {
    private static final long serialVersionUID = 3737479560067059961L;
    @XmlElement(name="batchid", required=true)
    @NotNull
    private Long batchId;
    @NotNull
    @IsRestrictedString
    @XmlElement(name="externalid", required=true)
    private String externalId;
    @NotNull
    @IsRestrictedString
    @XmlElement(name="financialtransactiontype", required=true)
    private String financialTransactionType;
    @XmlElement(name="financialtransactionid", required=false)
    private Long financialTransactionId;
    @XmlElement(name="originalfinancialtransactionid", required=false)
    private Long originalFinancialTransactionId;
    @XmlElement(name="transactionid", required=false)
    private Long transactionId;
    @NotNull
    @XmlElement(name="lastupdatedate", required=true)
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date lastUpdateDate;
    @NotNull
    @XmlElement(name="status", required=true)
    private BatchItemStatus status;
    @Valid
    @NotNull
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Valid
    @NotNull
    @XmlElement(name="fromfri", type=FRIValue.class, required=true)
    private FRIValue fromFri;
    @IsRestrictedString
    @XmlElement(name="frommessage", required=false)
    private String fromMessage;
    @IsFirstname
    @XmlElement(name="senderfirstname", required=false)
    private String senderFirstname;
    @IsSurname
    @XmlElement(name="sendersurname", required=false)
    private String senderSurname;
    @Valid
    @XmlElement(name="tofri", type=FRIValue.class, required=false)
    private FRIValue toFri;
    @IsRestrictedString
    @XmlElement(name="tomessage", required=false)
    private String toMessage;
    @IsFirstname
    @XmlElement(name="receiverfirstname", required=false)
    private String receiverFirstname;
    @IsSurname
    @XmlElement(name="receiversurname", required=false)
    private String receiverSurname;
    @IsDateString
    @XmlElement(name="todateofbirth", required=false)
    private String toDateOfBirth;
    @XmlElement(name="toidentificationtype", type=PersonIdentificationType1Code.class, required=false)
    private PersonIdentificationType1Code toIdentificationType;
    @IsRestrictedString
    @Length(max=32)
    @XmlElement(name="toidentification", required=false)
    private String toIdentification;
    @Length(max=16)
    @IsMSISDN
    @XmlElement(name="tomsisdn", required=false)
    private String toMsisdn;
    @IsEmail
    @XmlElement(name="toemail", required=false)
    private String toEmail;
    @Length(max=64)
    @IsUsername
    @XmlElement(name="tousername", required=false)
    private String toUsername;
    @IsRestrictedString
    @XmlElement(name="toexternalid", required=false)
    private String toExternalId;
    @IsAlias
    @XmlElement(name="toalias", required=false)
    private String toAlias;
    @IsLanguage
    @XmlElement(name="tolanguagecode", required=false)
    private String toLanguageCode;
    @IsRestrictedString
    @XmlElement(name="comment", required=false)
    private String comment;
    @IsRestrictedString
    @XmlElement(name="errordescription", required=false)
    private String errorDescription;
    @IsIdentity
    @XmlElement(name="accountholderidentity")
    private String accountHolderIdentity;
    @IsBankDomain
    @XmlElement(name="frombankdomain")
    private String fromBankDomain;
    @IsBankDomain
    @XmlElement(name="tobankdomain")
    private String toBankDomain;
    @IsRestrictedString
    @XmlElement(name="additionalinformation", required=false)
    private String additionalInformation;
    @IsRestrictedString
    @XmlElement(name="tofsp", required=false)
    private String toFsp;
    @Valid
    @XmlElement(name="productid", type=ProductIdValue.class)
    private ProductIdValue productId;
    @Valid
    @XmlElement(name="productofferingid", type=ProductOfferingIdValue.class)
    private ProductOfferingIdValue productOfferingId;

    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public Long getBatchId() {
        return this.batchId;
    }

    public String getComment() {
        return this.comment;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public String getFinancialTransactionType() {
        return this.financialTransactionType;
    }

    public FRIValue getFromFri() {
        return this.fromFri;
    }

    public String getFromMessage() {
        return this.fromMessage;
    }

    public String getToIdentification() {
        return this.toIdentification;
    }

    public DateTime getLastUpdateDate() {
        return this.lastUpdateDate == null ? null : new DateTime(this.lastUpdateDate);
    }

    public Long getOriginalFinancialTransactionId() {
        return this.originalFinancialTransactionId;
    }

    public String getReceiverFirstname() {
        return this.receiverFirstname;
    }

    public String getReceiverSurname() {
        return this.receiverSurname;
    }

    public String getSenderFirstname() {
        return this.senderFirstname;
    }

    public String getSenderSurname() {
        return this.senderSurname;
    }

    public BatchItemStatus getStatus() {
        return this.status;
    }

    public String getToAlias() {
        return this.toAlias;
    }

    public String getToDateOfBirth() {
        return this.toDateOfBirth;
    }

    public String getToEmail() {
        return this.toEmail;
    }

    public FRIValue getToFri() {
        return this.toFri;
    }

    public PersonIdentificationType1Code getToIdentificationType() {
        return this.toIdentificationType;
    }

    public String getToLanguageCode() {
        return this.toLanguageCode;
    }

    public String getToMessage() {
        return this.toMessage;
    }

    public String getToMsisdn() {
        return this.toMsisdn;
    }

    public String getToUsername() {
        return this.toUsername;
    }

    public String getToExternalId() {
        return this.toExternalId;
    }

    public Long getTransactionId() {
        return this.transactionId;
    }

    public String getAccountHolderIdentity() {
        return this.accountHolderIdentity;
    }

    public String getFromBankDomain() {
        return this.fromBankDomain;
    }

    public String getToBankDomain() {
        return this.toBankDomain;
    }

    public String getToFsp() {
        return this.toFsp;
    }

    public ProductIdValue getProductId() {
        return this.productId;
    }

    public ProductOfferingIdValue getProductOfferingId() {
        return this.productOfferingId;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public void setFinancialTransactionType(String financialTransactionType) {
        this.financialTransactionType = financialTransactionType;
    }

    public void setFromFri(FRIValue fromFri) {
        this.fromFri = fromFri;
    }

    public void setFromMessage(String fromMessage) {
        this.fromMessage = fromMessage;
    }

    public void setToIdentification(String identification) {
        this.toIdentification = identification;
    }

    public void setLastUpdateDate(DateTime lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate == null ? null : lastUpdateDate.toDate();
    }

    public void setOriginalFinancialTransactionId(Long originalFinancialTransactionId) {
        this.originalFinancialTransactionId = originalFinancialTransactionId;
    }

    public void setReceiverFirstname(String receiverFirstname) {
        this.receiverFirstname = receiverFirstname;
    }

    public void setReceiverSurname(String receiverSurname) {
        this.receiverSurname = receiverSurname;
    }

    public void setSenderFirstname(String senderFirstname) {
        this.senderFirstname = senderFirstname;
    }

    public void setSenderSurname(String senderSurname) {
        this.senderSurname = senderSurname;
    }

    public void setStatus(BatchItemStatus status) {
        this.status = status;
    }

    public void setToAlias(String toAlias) {
        this.toAlias = toAlias;
    }

    public void setToDateOfBirth(String toDateOfBirth) {
        this.toDateOfBirth = toDateOfBirth;
    }

    public void setToEmail(String toEmail) {
        this.toEmail = toEmail;
    }

    public void setToFri(FRIValue toFri) {
        this.toFri = toFri;
    }

    public void setToIdentificationType(PersonIdentificationType1Code toIdentificationType) {
        this.toIdentificationType = toIdentificationType;
    }

    public void setToLanguageCode(String toLanguageCode) {
        this.toLanguageCode = toLanguageCode;
    }

    public void setToMessage(String toMessage) {
        this.toMessage = toMessage;
    }

    public void setToMsisdn(String toMsisdn) {
        this.toMsisdn = toMsisdn;
    }

    public void setToUsername(String toUsername) {
        this.toUsername = toUsername;
    }

    public void setToExternalId(String toExternalId) {
        this.toExternalId = toExternalId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = transactionId;
    }

    public void setAccountHolderIdentity(String accountHolderIdentity) {
        this.accountHolderIdentity = accountHolderIdentity;
    }

    public void setFromBankDomain(String fromBankDomain) {
        this.fromBankDomain = fromBankDomain;
    }

    public void setToBankDomain(String toBankDomain) {
        this.toBankDomain = toBankDomain;
    }

    public void setToFsp(String toFsp) {
        this.toFsp = toFsp;
    }

    public void setProductId(ProductIdValue productId) {
        this.productId = productId;
    }

    public void setProductOfferingId(ProductOfferingIdValue productOfferingId) {
        this.productOfferingId = productOfferingId;
    }
}

