/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.campaignmanagement.hidden.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.AmountValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/campaignmanagement/hidden/v1_0/common", name="incentive", propOrder={"incentiveValue", "incentiveValueFixed"})
public class Incentive
implements Serializable {
    private static final long serialVersionUID = -8710625723292696542L;
    @NotNull
    @Valid
    @XmlElement(name="incentivevalue", type=AmountValue.class, required=true)
    private AmountValue incentiveValue;
    @Valid
    @XmlElement(name="incentivevaluefixed", defaultValue="true")
    private boolean incentiveValueFixed = Boolean.TRUE;

    public AmountValue getIncentiveValue() {
        return this.incentiveValue;
    }

    public void setIncentiveValue(AmountValue incentiveValue) {
        this.incentiveValue = incentiveValue;
    }

    public boolean isIncentiveValueFixed() {
        return this.incentiveValueFixed;
    }

    public void setIncentiveValueFixed(boolean incentiveValueFixed) {
        this.incentiveValueFixed = incentiveValueFixed;
    }

    public static Incentive fromLong(long incentiveValue, boolean valueFixed) {
        Incentive incentive = new Incentive();
        incentive.setIncentiveValue(AmountValue.fromLong(incentiveValue));
        incentive.setIncentiveValueFixed(valueFixed);
        return incentive;
    }

    public static Incentive fromBigDecimal(BigDecimal incentiveValue, boolean valueFixed) {
        Incentive incentive = new Incentive();
        incentive.setIncentiveValue(AmountValue.fromBigDecimal(incentiveValue));
        incentive.setIncentiveValueFixed(valueFixed);
        return incentive;
    }

    public String toString() {
        return "Incentive{incentiveValue=" + this.incentiveValue.getValueAsString() + ", incentiveValueFixed=" + this.incentiveValueFixed + "}";
    }

    public String toAuditLogString() {
        return "{incentiveValue=" + this.incentiveValue.getValueAsString() + ", incentiveValueFixed=" + this.incentiveValueFixed + "}";
    }
}

