/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.cashvoucher.v1_0.getcashvouchers;

import com.ericsson.em.m3if.cashvoucher.v1_0.common.CashVoucherStatus;
import com.ericsson.em.m3if.operations.annotations.SensitiveValue;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.validators.IsASCIIToken;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.Length;
import iso.std.iso._20022.tech.xsd.PersonIdentificationType1Code;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/cashvoucher/v1_0", name="getcashvouchersrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/cashvoucher/v1_0", name="", propOrder={"token", "senderMsisdn", "senderName", "senderLastName", "identificationType", "identificationNumber", "maxNumOfCashVouchers", "indexOffset", "startDate", "endDate", "status"})
public class GetCashVouchersRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    private static final int DEFAULT_MAXLIMIT = 50;
    @Length(max=32)
    @IsASCIIToken
    @SensitiveValue
    @XmlElement(name="token", required=false)
    private String token;
    @Length(max=16)
    @IsMSISDN
    @XmlElement(name="sendermsisdn", required=false)
    private String senderMsisdn;
    @IsFirstname
    @XmlElement(name="sendername", required=false)
    private String senderName;
    @IsSurname
    @XmlElement(name="senderlastname", required=false)
    private String senderLastName;
    @XmlElement(name="identificationtype", type=PersonIdentificationType1Code.class, required=false)
    private PersonIdentificationType1Code identificationType;
    @IsRestrictedString
    @Length(max=32)
    @XmlElement(name="identificationnumber", required=false)
    private String identificationNumber;
    @XmlElement(name="maxnumofcashvouchers", defaultValue="50", required=false)
    @Min(value=1L)
    private @Min(value=1L) int maxNumOfCashVouchers = 50;
    @Min(value=0L)
    @XmlElement(name="indexoffset", defaultValue="0", required=false)
    private @Min(value=0L) int indexOffset = 0;
    @XmlElement(name="startdate", required=false)
    private Date startDate;
    @XmlElement(name="enddate", required=false)
    private Date endDate;
    @Valid
    @XmlElement(name="status", type=CashVoucherStatus.class, required=false)
    private CashVoucherStatus status;

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSenderMsisdn() {
        return this.senderMsisdn;
    }

    public void setSenderMsisdn(String senderMsisdn) {
        this.senderMsisdn = senderMsisdn;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getSenderLastName() {
        return this.senderLastName;
    }

    public void setSenderLastName(String senderLastName) {
        this.senderLastName = senderLastName;
    }

    public PersonIdentificationType1Code getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(PersonIdentificationType1Code identificationType) {
        this.identificationType = identificationType;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public int getMaxNumOfCashVouchers() {
        return this.maxNumOfCashVouchers;
    }

    public void setMaxNumOfCashVouchers(int maxNumOfCashVouchers) {
        this.maxNumOfCashVouchers = maxNumOfCashVouchers;
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(int indexOffset) {
        this.indexOffset = indexOffset;
    }

    public DateTime getStartDate() {
        return DateHelper.fromDate(this.startDate);
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = DateHelper.toDate(startDate);
    }

    public DateTime getEndDate() {
        return DateHelper.fromDate(this.endDate);
    }

    public void setEndDate(DateTime endDate) {
        this.endDate = DateHelper.toDate(endDate);
    }

    public CashVoucherStatus getStatus() {
        return this.status;
    }

    public void setStatus(CashVoucherStatus status) {
        this.status = status;
    }
}

