/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.common;

import com.ericsson.em.m3if.financial.v1_0.common.UnclaimedFundsAccountDetails;
import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0/common", name="accountholder", propOrder={"internalIdentity", "firstName", "surname", "closingDate", "unclaimedFundsAccounts"})
public class ClosedAccountHolderDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsIdentity
    @XmlElement(name="internalidentity")
    private String internalIdentity;
    @IsFirstname
    @XmlElement(name="firstname")
    private String firstName;
    @IsSurname
    @XmlElement(name="surname")
    private String surname;
    @XmlElement(name="closingdate")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date closingDate;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="accounts")
    @XmlElements(value={@XmlElement(name="account", type=UnclaimedFundsAccountDetails.class)})
    private List<UnclaimedFundsAccountDetails> unclaimedFundsAccounts = new ArrayList<UnclaimedFundsAccountDetails>();

    public String getInternalIdentity() {
        return this.internalIdentity;
    }

    public void setInternalIdentity(String internalIdentity) {
        this.internalIdentity = internalIdentity;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public DateTime getClosingDate() {
        return DateHelper.fromDate(this.closingDate);
    }

    public void setClosingDate(DateTime closingDate) {
        this.closingDate = DateHelper.toDate(closingDate);
    }

    public List<UnclaimedFundsAccountDetails> getUnclaimedFundsAccounts() {
        return this.unclaimedFundsAccounts;
    }

    public void setUnclaimedFundsAccounts(List<UnclaimedFundsAccountDetails> unclaimedFundsAccounts) {
        this.unclaimedFundsAccounts = unclaimedFundsAccounts;
    }
}

