/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.emptyaccount;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="emptyaccountrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="", propOrder={"fromFRI", "toFRI", "fromMessage", "toMessage", "cause", "quoteId", "reason"})
public class EmptyAccountRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromfri", required=true)
    private String fromFRI;
    @IsFinancialResourceIdentifier
    @XmlElement(name="tofri")
    private String toFRI;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="frommessage")
    private String fromMessage;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="tomessage")
    private String toMessage;
    @Length(max=128)
    @IsRestrictedString
    @XmlElement(name="cause")
    private String cause;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @NotBlank
    @Length(min=1, max=512)
    @IsMultilineRestrictedString
    @XmlElement(name="reason", required=true)
    private String reason;

    public EmptyAccountRequest() {
    }

    public EmptyAccountRequest(String fromFRI, String reason) {
        this.fromFRI = fromFRI;
        this.reason = reason;
    }

    public String getFromFRI() {
        return this.fromFRI;
    }

    public void setFromFRI(String fromFRI) {
        this.fromFRI = fromFRI;
    }

    public String getToFRI() {
        return this.toFRI;
    }

    public void setToFRI(String toFRI) {
        this.toFRI = toFRI;
    }

    public String getFromMessage() {
        return this.fromMessage;
    }

    public void setFromMessage(String fromMessage) {
        this.fromMessage = fromMessage;
    }

    public String getToMessage() {
        return this.toMessage;
    }

    public void setToMessage(String toMessage) {
        this.toMessage = toMessage;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

