/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_1.cashinwithotp;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ClientReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsASCIIToken;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_1", name="cashinwithotprequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_1", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "otp", "quoteId", "clientReferenceId", "externalTransactionId"})
public class CashInWithOtpRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="sendingfri")
    private FRIValue sendingFRI;
    @NotNull
    @Valid
    @XmlElement(name="receivingfri", required=true)
    private FRIValue receivingFRI;
    @NotNull
    @Valid
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote")
    private String senderNote;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="receivermessage")
    private String receiverMessage;
    @NotNull
    @IsASCIIToken
    @XmlElement(name="otp", required=true)
    private String otp;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="clientreferenceid", type=ClientReferenceIdValue.class)
    private ClientReferenceIdValue clientReferenceId;
    @Valid
    @XmlElement(name="externaltransactionid", type=ExternalTransactionIdValue.class)
    private ExternalTransactionIdValue externalTransactionId;

    public CashInWithOtpRequest() {
    }

    public CashInWithOtpRequest(FRIValue sendingFRI, FRIValue receivingFRI, MoneyDetails amount, String otp) {
        this.sendingFRI = sendingFRI;
        this.receivingFRI = receivingFRI;
        this.amount = amount;
        this.otp = otp;
    }

    public CashInWithOtpRequest(FRIValue sendingFRI, FRIValue receivingFRI, MoneyDetails amount, String otp, String senderNote, String receiverMessage) {
        this(sendingFRI, receivingFRI, amount, otp);
        this.senderNote = senderNote;
        this.receiverMessage = receiverMessage;
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public FRIValue getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(FRIValue receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public String getOtp() {
        return this.otp;
    }

    public void setOtp(String otp) {
        this.otp = otp;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Optional<ClientReferenceIdValue> getClientReferenceId() {
        return Optional.ofNullable(this.clientReferenceId);
    }

    public void setClientReferenceId(ClientReferenceIdValue clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    public Optional<ExternalTransactionIdValue> getExternalTransactionId() {
        return Optional.ofNullable(this.externalTransactionId);
    }

    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }
}

