/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_2.getcustodyaccounttransactionhistory;

import com.ericsson.em.m3if.financial.v1_0.common.Direction;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionStatus;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v2_0.common.FinancialInstructionType;
import com.ericsson.em.validators.IsBankAccount;
import com.ericsson.em.validators.IsBankCode;
import com.ericsson.em.validators.IsDateTime;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_2", name="getcustodyaccounttransactionhistoryrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_2", name="", propOrder={"bankCode", "accountNumber", "numOfTransactions", "indexOffset", "financialTransactionId", "externalTransactionId", "transactionStatus", "transactionType", "startDateFrom", "startDateTo", "dateFrom", "dateTo", "direction", "otherFri", "quoteId"})
public class GetCustodyAccountTransactionHistoryRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.2";
    private static final int DEFAULT_MAXLIMIT = 50;
    @IsBankCode
    @XmlElement(name="bankcode", required=false)
    private String bankCode;
    @NotNull
    @IsBankAccount
    @XmlElement(name="accountnumber", required=true)
    private String accountNumber;
    @Min(value=1L)
    @NotNull
    @XmlElement(name="numoftransactions", defaultValue="50", required=true)
    private @Min(value=1L) @NotNull Integer numOfTransactions;
    @XmlElement(name="indexoffset", defaultValue="0")
    private int indexOffset = 0;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="financialtransactionid")
    private Long financialTransactionId;
    @IsExternalTransactionIdString
    @XmlElement(name="externaltransactionid")
    private String externalTransactionId;
    @XmlElement(name="transactionstatus")
    private FinancialTransactionStatus transactionStatus;
    @Valid
    @NoNullElements
    @XmlElement(name="transactiontype", type=FinancialInstructionType.class)
    private List<FinancialInstructionType> transactionType = new LinkedList<FinancialInstructionType>();
    @IsDateTime
    @XmlElement(name="startdatefrom")
    private XMLGregorianCalendar startDateFrom;
    @IsDateTime
    @XmlElement(name="startdateto")
    private XMLGregorianCalendar startDateTo;
    @IsDateTime
    @XmlElement(name="datefrom")
    private XMLGregorianCalendar dateFrom;
    @IsDateTime
    @XmlElement(name="dateto")
    private XMLGregorianCalendar dateTo;
    @XmlElement(name="direction")
    private Direction direction;
    @IsFinancialResourceIdentifier
    @XmlElement(name="otherfri")
    private String otherFri;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public GetCustodyAccountTransactionHistoryRequest() {
        this.numOfTransactions = 50;
    }

    public GetCustodyAccountTransactionHistoryRequest(String bankCode, String accountNumber) {
        this.setBankCode(bankCode);
        this.setAccountNumber(accountNumber);
        this.numOfTransactions = 50;
    }

    public GetCustodyAccountTransactionHistoryRequest(String bankCode, String accountNumber, int maxLimit) {
        this.setBankCode(bankCode);
        this.setAccountNumber(accountNumber);
        this.numOfTransactions = maxLimit;
    }

    public GetCustodyAccountTransactionHistoryRequest(String bankCode, String accountNumber, DateTime dateFrom, DateTime dateTo, int maxLimit, int indexOffset) {
        this.setBankCode(bankCode);
        this.setAccountNumber(accountNumber);
        this.dateFrom = DateHelper.fromDateTime(dateFrom);
        this.dateTo = DateHelper.fromDateTime(dateTo);
        this.numOfTransactions = maxLimit;
        this.indexOffset = indexOffset;
    }

    public DateTime getStartDateFrom() {
        return DateHelper.toDateTime(this.startDateFrom);
    }

    public void setStartDateFrom(DateTime startDateFrom) {
        this.startDateFrom = DateHelper.fromDateTime(startDateFrom);
    }

    public DateTime getStartDateTo() {
        return DateHelper.toDateTime(this.startDateTo);
    }

    public void setStartDateTo(DateTime startDateTo) {
        this.startDateTo = DateHelper.fromDateTime(startDateTo);
    }

    public DateTime getDateFrom() {
        return DateHelper.toDateTime(this.dateFrom);
    }

    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = DateHelper.fromDateTime(dateFrom);
    }

    public DateTime getDateTo() {
        return DateHelper.toDateTime(this.dateTo);
    }

    public void setDateTo(DateTime dateTo) {
        this.dateTo = DateHelper.fromDateTime(dateTo);
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(int indexOffset) {
        this.indexOffset = indexOffset;
    }

    public void setNumOfTransactions(int numOfTransactions) {
        this.numOfTransactions = numOfTransactions;
    }

    @XmlTransient
    public int getNumOfTransactions() {
        return this.numOfTransactions;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public String getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(String externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public FinancialTransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(FinancialTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public List<FinancialInstructionType> getTransactionType() {
        return this.transactionType;
    }

    public void addTransactionType(FinancialInstructionType transactionType) {
        this.transactionType.add(transactionType);
    }

    public void setTransactionType(List<FinancialInstructionType> transactionTypes) {
        this.transactionType = transactionTypes;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String getOtherFri() {
        return this.otherFri;
    }

    public void setOtherFri(String otherFri) {
        this.otherFri = otherFri;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    @AssertTrue(message="Financial instruction type not supported")
    private @AssertTrue(message="Financial instruction type not supported") boolean isNotUnknownType() {
        for (FinancialInstructionType type : this.transactionType) {
            if (type != FinancialInstructionType.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }
}

