/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_0.transfer;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.RequestReferenceId;
import com.ericsson.em.m3if.v1_0.common.ScheduledTransactionDate;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="transferrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "referenceId", "scheduled", "extension", "quoteId", "requestReferenceId"})
@Deprecated
public class TransferRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="sendingfri")
    private FRIValue sendingFRI;
    @Valid
    @NotNull
    @XmlElement(name="receivingfri", required=true)
    private FRIValue receivingFRI;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", required=true)
    private MoneyDetails amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote")
    private String senderNote;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="receivermessage")
    private String receiverMessage;
    @Length(min=1, max=64)
    @IsExternalReferenceString
    @XmlElement(name="referenceid")
    private String referenceId;
    @Valid
    @XmlElement(name="scheduled", type=ScheduledTransactionDate.class)
    private ScheduledTransactionDate scheduled;
    @Valid
    @XmlElement(name="extension")
    private ExtensionType extension;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="requestreferenceid", required=false)
    private RequestReferenceId requestReferenceId;

    public TransferRequest() {
    }

    public TransferRequest(FRIValue sendingFRI, FRIValue receivingFRI, MoneyDetails amount) {
        this.setSendingFRI(sendingFRI);
        this.setReceivingFRI(receivingFRI);
        this.setAmount(amount);
    }

    public TransferRequest(FRIValue sendingFRI, FRIValue receivingFRI, MoneyDetails amount, String senderNote, String receiverMessage, String referenceId, ExtensionType extension) {
        this(sendingFRI, receivingFRI, amount);
        this.setSenderNote(senderNote);
        this.setReceiverMessage(receiverMessage);
        this.setReferenceId(referenceId);
        this.setExtension(extension);
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public FRIValue getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(FRIValue receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public ScheduledTransactionDate getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(ScheduledTransactionDate scheduled) {
        this.scheduled = scheduled;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public RequestReferenceId getRequestReferenceId() {
        return this.requestReferenceId;
    }

    public void setRequestReferenceId(RequestReferenceId requestReferenceId) {
        this.requestReferenceId = requestReferenceId;
    }
}

