/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v3_1.merchantpayment;

import com.ericsson.em.m3if.financial.v1_0.quotation.Assistable;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.Coupon;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ReceiverMessageValue;
import com.ericsson.em.m3if.v1_0.common.RequestReferenceId;
import com.ericsson.em.m3if.v1_0.common.SenderNoteValue;
import com.ericsson.em.m3if.v1_3.common.ScheduledTransactionDate;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v3_1", name="merchantpaymentrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v3_1", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "quoteId", "coupon", "requestReferenceId", "extension", "scheduled", "includeOffNet", "transferType"})
public class MerchantPaymentRequest
implements Serializable,
QuoteRequest,
Assistable {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="sendingfri", type=FRIValue.class)
    private FRIValue sendingFRI;
    @Valid
    @NotNull
    @XmlElement(name="receivingfri", type=FRIValue.class, required=true)
    private FRIValue receivingFRI;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="sendernote", type=SenderNoteValue.class)
    private SenderNoteValue senderNote;
    @Valid
    @XmlElement(name="receivermessage", type=ReceiverMessageValue.class)
    private ReceiverMessageValue receiverMessage;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="coupon", type=Coupon.class)
    private Coupon coupon;
    @Valid
    @XmlElement(name="requestreferenceid", type=RequestReferenceId.class)
    private RequestReferenceId requestReferenceId;
    @Valid
    @XmlElement(name="extension", type=ExtensionType.class)
    private ExtensionType extension;
    @Valid
    @XmlElement(name="scheduled", type=ScheduledTransactionDate.class)
    private ScheduledTransactionDate scheduled;
    @XmlElement(name="includeoffnet", defaultValue="false")
    private Boolean includeOffNet = false;
    @Valid
    @XmlElement(name="transfertype", type=TransferType.class)
    private TransferType transferType;

    public MerchantPaymentRequest() {
    }

    public MerchantPaymentRequest(FRIValue from, FRIValue to, MoneyDetails amount) {
        this.sendingFRI = from;
        this.receivingFRI = to;
        this.amount = amount;
    }

    public MerchantPaymentRequest(FRIValue from, FRIValue to, MoneyDetails amount, String senderNote, String receiverMessage, ExtensionType extension) {
        this(from, to, amount);
        this.senderNote = SenderNoteValue.fromString(senderNote);
        this.receiverMessage = ReceiverMessageValue.fromString(receiverMessage);
        this.extension = extension;
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public Optional<FRIValue> getReceivingFRI() {
        return Optional.ofNullable(this.receivingFRI);
    }

    public void setReceivingFRI(FRIValue receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public Optional<SenderNoteValue> getSenderNote() {
        return Optional.ofNullable(this.senderNote);
    }

    public void setSenderNote(SenderNoteValue senderNote) {
        this.senderNote = senderNote;
    }

    public Optional<ReceiverMessageValue> getReceiverMessage() {
        return Optional.ofNullable(this.receiverMessage);
    }

    public void setReceiverMessage(ReceiverMessageValue receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Optional<Coupon> getCoupon() {
        return Optional.ofNullable(this.coupon);
    }

    public void setCoupon(Coupon coupon) {
        this.coupon = coupon;
    }

    public Optional<RequestReferenceId> getRequestReferenceId() {
        return Optional.ofNullable(this.requestReferenceId);
    }

    public void setRequestReferenceId(RequestReferenceId requestReferenceId) {
        this.requestReferenceId = requestReferenceId;
    }

    public Optional<ExtensionType> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    public Optional<ScheduledTransactionDate> getScheduled() {
        return Optional.ofNullable(this.scheduled);
    }

    public void setScheduled(ScheduledTransactionDate scheduled) {
        this.scheduled = scheduled;
    }

    public Optional<Boolean> getIncludeOffNet() {
        return Optional.ofNullable(this.includeOffNet);
    }

    public void setIncludeOffNet(Boolean includeOffNet) {
        this.includeOffNet = includeOffNet;
    }

    public Optional<TransferType> getTransferType() {
        return Optional.ofNullable(this.transferType);
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }
}

