/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.group.v1_1.creategroup;

import com.ericsson.em.m3if.group.v1_0.common.PropertyValue;
import com.ericsson.em.validators.IsPersonalName;
import com.ericsson.em.validators.IsProfileName;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/group/v1_1", name="creategrouprequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/group/v1_1", name="", propOrder={"name", "profile", "parameters"})
public class CreateGroupRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.1";
    @XmlElement(name="name", required=true)
    @NotBlank
    @Length(max=128)
    @IsPersonalName
    private String name;
    @XmlElement(name="profile", required=true)
    @NotBlank
    @Length(max=64)
    @IsProfileName
    private String profile;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="parameters")
    @XmlElements(value={@XmlElement(name="parameter", required=false, type=PropertyValue.class)})
    private List<PropertyValue> parameters;

    public CreateGroupRequest() {
    }

    public CreateGroupRequest(String name, String profile) {
        this.name = name;
        this.profile = profile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public List<PropertyValue> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<PropertyValue> parameters) {
        this.parameters = parameters;
    }

    public void setParametersAsStrings(List<String> parameters) {
        if (parameters != null) {
            ArrayList<PropertyValue> list = new ArrayList<PropertyValue>(parameters.size());
            for (String string : parameters) {
                list.add(new PropertyValue(string));
            }
            this.parameters = list;
        }
    }

    public List<String> convertToStringList() {
        if (this.parameters != null) {
            ArrayList<String> list = new ArrayList<String>(this.parameters.size());
            for (PropertyValue propertyValue : this.parameters) {
                list.add(propertyValue.getPropertyValue());
            }
            return list;
        }
        return null;
    }
}

