/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.overdraft.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.validators.MaxDecimalDigits;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Currency;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/overdraft/v1_0/common", name="interest", propOrder={"currency", "interestPercentage"})
public class Interest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="currency", type=CurrencyCode.class, required=true)
    private CurrencyCode currency;
    @Valid
    @Min(value=0L)
    @Max(value=100L)
    @MaxDecimalDigits(value=2)
    @XmlElement(name="interestpercentage", type=BigDecimal.class)
    private @Valid @Min(value=0L) @Max(value=100L) BigDecimal interestPercentage;

    public BigDecimal getInterestPercentage() {
        return this.interestPercentage;
    }

    public CurrencyCode getCurrency() {
        return this.currency;
    }

    public static Interest fromPercentage(Currency currency, BigDecimal interestPercentage) {
        Interest interest = new Interest();
        interest.currency = CurrencyCode.from(currency);
        interest.interestPercentage = interestPercentage;
        return interest;
    }

    public String toString() {
        return "Interest{currency=" + this.currency.getCode() + ", interestPercentage=" + (this.interestPercentage == null ? BigDecimal.ZERO : this.interestPercentage) + "}";
    }
}

