/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.overdraft.v1_0.common;

import com.ericsson.em.m3if.overdraft.v1_0.common.AccessFee;
import com.ericsson.em.m3if.overdraft.v1_0.common.Interest;
import com.ericsson.em.m3if.v1_0.common.EntityId;
import com.ericsson.em.m3if.v1_0.common.NameValue;
import com.ericsson.em.m3if.v1_0.common.Profile;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/overdraft/v1_0/common", name="overdraftchargesrule", propOrder={"ruleId", "ruleName", "accessFee", "interestRate", "userProfiles"})
public class OverdraftChargesRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="ruleid", type=EntityId.class, required=true)
    private EntityId ruleId;
    @Valid
    @NotNull
    @XmlElement(name="rulename", type=NameValue.class, required=true)
    private NameValue ruleName;
    @Valid
    @NotNull
    @XmlElement(name="accessfee", type=AccessFee.class, required=true)
    private AccessFee accessFee;
    @Valid
    @NotNull
    @XmlElement(name="interestrate", type=Interest.class, required=true)
    private Interest interestRate;
    @Valid
    @NotNull
    @NoNullElements
    @XmlElementWrapper(name="userprofiles", required=true)
    @XmlElements(value={@XmlElement(name="userprofile", type=Profile.class)})
    @Size(min=1)
    private @Valid @NotNull @Size(min=1) List<Profile> userProfiles;

    OverdraftChargesRule() {
    }

    OverdraftChargesRule(Builder builder) {
        this.ruleId = EntityId.from(builder.ruleId);
        this.ruleName = NameValue.fromString(builder.ruleName);
        this.accessFee = builder.accessFee;
        this.interestRate = builder.interest;
        this.userProfiles = builder.userProfiles;
    }

    public EntityId getRuleId() {
        return this.ruleId;
    }

    public NameValue getRuleName() {
        return this.ruleName;
    }

    public AccessFee getAccessFee() {
        return this.accessFee;
    }

    public Interest getInterestRate() {
        return this.interestRate;
    }

    public List<Profile> getUserProfiles() {
        return this.userProfiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public String toString() {
        return "OverdraftChargesRule{ruleId=" + (Serializable)(this.ruleId == null ? "null" : this.ruleId.getValue()) + ", ruleName=" + this.ruleName + ", accessFee=" + this.accessFee + ", interestRate=" + this.interestRate + ", userProfiles=" + this.userProfiles + "}";
    }

    public static final class Builder {
        private Long ruleId;
        private String ruleName;
        private AccessFee accessFee;
        private Interest interest;
        private List<Profile> userProfiles;

        Builder() {
        }

        Builder(OverdraftChargesRule overdraftChargesRule) {
            this.ruleId = overdraftChargesRule.ruleId.getValue();
            this.ruleName = overdraftChargesRule.ruleName.toString();
            this.accessFee = overdraftChargesRule.accessFee;
            this.interest = overdraftChargesRule.interestRate;
            this.userProfiles = overdraftChargesRule.userProfiles;
        }

        public Builder ruleId(Long ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public Builder accessFee(AccessFee accessFee) {
            this.accessFee = accessFee;
            return this;
        }

        public Builder interestRate(Interest interest) {
            this.interest = interest;
            return this;
        }

        public Builder userProfiles(List<Profile> userProfiles) {
            this.userProfiles = userProfiles;
            return this;
        }

        public OverdraftChargesRule build() {
            return Validation.validate(new OverdraftChargesRule(this));
        }
    }
}

