/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.addaccount;

import com.ericsson.em.m3if.v1_0.common.AccountType;
import com.ericsson.em.validators.IsCurrencyCode;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultiWordString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="addaccountrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="", propOrder={"identity", "accountType", "profileName", "accountRefProfileName", "currency"})
public class AddAccountRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @IsIdentity
    @XmlElement(name="identity", required=false)
    private String identity;
    @NotNull
    @Valid
    @XmlElement(name="accounttype", required=true)
    private AccountType accountType;
    @NotNull
    @NotBlank
    @IsMultiWordString
    @XmlElement(name="profilename", required=true)
    private String profileName;
    @Length(min=1)
    @IsMultiWordString
    @XmlElement(name="accountrefprofilename", required=false)
    private String accountRefProfileName;
    @IsCurrencyCode
    @XmlElement(name="currency", required=false)
    private String currency;

    public AddAccountRequest() {
    }

    public AddAccountRequest(String identity, AccountType accountType, String profileName, String accountRefProfileName, String currency) {
        this.identity = identity;
        this.accountType = accountType;
        this.profileName = profileName;
        this.accountRefProfileName = accountRefProfileName;
        this.currency = currency;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getAccountRefProfileName() {
        return this.accountRefProfileName;
    }

    public void setAccountRefProfileName(String accountRefProfileName) {
        this.accountRefProfileName = accountRefProfileName;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }
}

