/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.common;

import com.ericsson.em.m3if.operations.validation.NotFutureDate;
import com.ericsson.em.validators.IsDateString;
import com.ericsson.em.validators.IsGeographicalName;
import com.ericsson.em.validators.Length;
import com.google.common.base.Strings;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.LocalDate;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0/common", name="birthinformation", propOrder={"date", "country", "province", "city"})
public class BirthInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsDateString(format=IsDateString.DATE_FORMAT.ISO, minDate="1890-01-01")
    @NotFutureDate
    @XmlElement(name="date")
    private String date;
    @IsGeographicalName
    @Length(max=16)
    @XmlElement(name="country")
    private String country;
    @IsGeographicalName
    @Length(max=48)
    @XmlElement(name="province")
    private String province;
    @IsGeographicalName
    @Length(max=48)
    @XmlElement(name="city")
    private String city;

    public LocalDate getDate() {
        return Strings.isNullOrEmpty(this.date) ? null : LocalDate.parse(this.date);
    }

    public void setDate(LocalDate localDate) {
        this.date = localDate == null ? "" : localDate.toString(IsDateString.DATE_FORMAT.ISO.getFormat());
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.city == null ? 0 : this.city.hashCode());
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.province == null ? 0 : this.province.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BirthInformation other = (BirthInformation)obj;
        if (this.city == null ? other.city != null : !this.city.equals(other.city)) {
            return false;
        }
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        return !(this.province == null ? other.province != null : !this.province.equals(other.province));
    }
}

