/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.common;

import com.ericsson.em.m3if.operations.validation.NotFutureDate;
import com.ericsson.em.m3if.provisioning.v1_0.common.Relation;
import com.ericsson.em.m3if.provisioning.v1_0.common.RelationType;
import com.ericsson.em.m3if.v1_0.common.EmailAddress;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MiddlenameValue;
import com.ericsson.em.m3if.v1_0.common.PhoneNumber;
import com.ericsson.em.validators.IsAddress;
import com.ericsson.em.validators.IsEnum;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsGeographicalName;
import com.ericsson.em.validators.IsIsoPhoneNumber;
import com.ericsson.em.validators.IsPostalCode;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.Length;
import iso.std.iso._20022.tech.xsd.PersonIdentificationType1Code;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0/common", name="relativeinformation", propOrder={"relativeId", "relationType", "firstName", "surname", "idNumber", "idType", "phoneNumber", "streetName", "addressLine1", "postalCode", "city", "province", "country", "relation", "middleName", "email", "alternateNumber", "dateOfBirth", "idExpiryDate"})
public class RelativeInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="relativeid")
    private Long relativeId;
    @IsEnum(type=RelationType.class)
    @NotNull
    @Length(max=32)
    @XmlElement(name="relationtype", required=true)
    private String relationType;
    @IsFirstname
    @XmlElement(name="firstname")
    private String firstName;
    @IsSurname
    @XmlElement(name="surname")
    private String surname;
    @IsRestrictedString
    @Length(min=1, max=64)
    @XmlElement(name="idnumber")
    protected String idNumber;
    @Valid
    @XmlElement(name="idtype")
    protected PersonIdentificationType1Code idType;
    @IsIsoPhoneNumber
    @Length(max=30)
    @XmlElement(name="phonenumber")
    protected String phoneNumber;
    @IsAddress
    @Length(max=128)
    @XmlElement(name="streetname")
    protected String streetName;
    @IsAddress
    @Length(max=128)
    @XmlElement(name="addressline1")
    protected String addressLine1;
    @IsPostalCode
    @Length(max=64)
    @XmlElement(name="postalcode")
    protected String postalCode;
    @IsGeographicalName
    @Length(max=64)
    @XmlElement(name="city")
    protected String city;
    @IsGeographicalName
    @Length(max=64)
    @XmlElement(name="province")
    protected String province;
    @IsGeographicalName
    @Length(max=64)
    @XmlElement(name="country")
    protected String country;
    @Valid
    @XmlElement(name="relation", type=Relation.class)
    protected Relation relation;
    @Valid
    @XmlElement(name="middlename", type=MiddlenameValue.class)
    protected MiddlenameValue middleName;
    @Valid
    @XmlElement(name="email", type=EmailAddress.class)
    protected EmailAddress email;
    @Valid
    @XmlElement(name="alternatenumber", type=PhoneNumber.class)
    protected PhoneNumber alternateNumber;
    @Valid
    @NotFutureDate
    @XmlElement(name="dateofbirth")
    protected Iso8601DateTime dateOfBirth;
    @Valid
    @XmlElement(name="idexpirydate")
    protected Iso8601DateTime idExpiryDate;

    public RelativeInformation() {
    }

    public RelativeInformation(RelationType relationType) {
        this.relationType = relationType.name();
    }

    public Long getRelativeId() {
        return this.relativeId;
    }

    public void setRelativeId(Long relativeId) {
        this.relativeId = relativeId;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surName) {
        this.surname = surName;
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public PersonIdentificationType1Code getIdType() {
        return this.idType;
    }

    public void setIdType(PersonIdentificationType1Code idType) {
        this.idType = idType;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phone) {
        this.phoneNumber = phone;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getRelation() {
        return this.relation != null ? this.relation.getValueAsString() : null;
    }

    public void setRelation(String relation) {
        this.relation = Relation.fromString(relation);
    }

    public String getMiddleName() {
        return this.middleName != null ? this.middleName.getValueAsString() : null;
    }

    public void setMiddleName(String middleName) {
        this.middleName = MiddlenameValue.fromString(middleName);
    }

    public String getEmail() {
        return this.email != null ? this.email.getValueAsString() : null;
    }

    public void setEmail(String email) {
        this.email = EmailAddress.fromString(email);
    }

    public String getAlternateNumber() {
        return this.alternateNumber != null ? this.alternateNumber.getValueAsString() : null;
    }

    public void setAlternateNumber(String alternateNumber) {
        this.alternateNumber = PhoneNumber.fromString(alternateNumber);
    }

    public Iso8601DateTime getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Iso8601DateTime dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Iso8601DateTime getIdExpiryDate() {
        return this.idExpiryDate;
    }

    public void setIdExpiryDate(Iso8601DateTime idExpiryDate) {
        this.idExpiryDate = idExpiryDate;
    }
}

