/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.initiatepasswordreset;

import com.ericsson.em.m3if.provisioning.v1_0.common.AttemptsValue;
import com.ericsson.em.m3if.provisioning.v1_0.initiatepasswordreset.InitiatePasswordResetRequest;
import com.ericsson.em.m3if.provisioning.v1_1.common.CredentialStatusType;
import com.ericsson.em.m3if.v1_0.common.CredentialTypeValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.NotificationChannelTypeValue;
import com.ericsson.em.m3if.v1_0.common.ReasonMessageValue;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.NoNullElements;
import com.google.common.base.Strings;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="initiatepasswordresetapprovalrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="", propOrder={"reason", "credentialType", "lastSuccessfulCredentialReset", "lastCredentialResetAttempt", "lastLogin", "failedLoginAttempts", "lastLoginAttempt", "otpChannels", "credentialStatus"})
public class InitiatePasswordResetApprovalRequest
extends InitiatePasswordResetRequest {
    @Valid
    @XmlElement(name="note", type=ReasonMessageValue.class)
    private ReasonMessageValue reason;
    @Valid
    @XmlElement(name="credentialtype", type=CredentialTypeValue.class)
    private CredentialTypeValue credentialType;
    @Valid
    @XmlElement(name="lastsuccessfulcredentialdreset", type=Iso8601DateTime.class)
    private Iso8601DateTime lastSuccessfulCredentialReset;
    @Valid
    @XmlElement(name="lastcredentialresetattempt", type=Iso8601DateTime.class)
    private Iso8601DateTime lastCredentialResetAttempt;
    @Valid
    @XmlElement(name="lastlogin", type=Iso8601DateTime.class)
    private Iso8601DateTime lastLogin;
    @Valid
    @XmlElement(name="failedloginattempts", type=AttemptsValue.class)
    private AttemptsValue failedLoginAttempts;
    @Valid
    @XmlElement(name="lastloginattempt", type=Iso8601DateTime.class)
    private Iso8601DateTime lastLoginAttempt;
    @Valid
    @NotNull
    @NoNullElements
    @XmlElementWrapper(name="otpchannels", required=true)
    @XmlElements(value={@XmlElement(name="otpchannel", type=NotificationChannelTypeValue.class)})
    private List<NotificationChannelTypeValue> otpChannels;
    @Valid
    @XmlElement(name="credentialstatus", type=CredentialStatusType.class)
    private CredentialStatusType credentialStatus;

    public static Builder builder() {
        return new Builder();
    }

    public InitiatePasswordResetApprovalRequest() {
    }

    private InitiatePasswordResetApprovalRequest(Builder builder) {
        this.setReason(builder.initiatePasswordResetRequest.getReason());
        this.setAccountholderId(builder.initiatePasswordResetRequest.getAccountholderId());
        this.reason = builder.initiatePasswordResetRequest.getReason();
        this.credentialType = builder.credentialType;
        this.lastSuccessfulCredentialReset = builder.lastSuccessfulCredentialReset;
        this.lastCredentialResetAttempt = builder.lastCredentialResetAttempt;
        this.lastLogin = builder.lastLogin;
        this.failedLoginAttempts = builder.failedLoginAttempts;
        this.lastLoginAttempt = builder.lastLoginAttempt;
        this.credentialStatus = builder.credentialStatus;
        this.otpChannels = builder.otpChannels;
    }

    @Override
    public ReasonMessageValue getReason() {
        return this.reason;
    }

    public CredentialTypeValue getCredentialType() {
        return this.credentialType;
    }

    public Iso8601DateTime getLastSuccessfulCredentialReset() {
        return this.lastSuccessfulCredentialReset;
    }

    public Iso8601DateTime getLastCredentialResetAttempt() {
        return this.lastCredentialResetAttempt;
    }

    public Iso8601DateTime getLastLogin() {
        return this.lastLogin;
    }

    public AttemptsValue getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public Iso8601DateTime getLastLoginAttempt() {
        return this.lastLoginAttempt;
    }

    public CredentialStatusType getCredentialStatus() {
        return this.credentialStatus;
    }

    public List<NotificationChannelTypeValue> getOtpChannels() {
        return this.otpChannels;
    }

    public static final class Builder {
        private CredentialTypeValue credentialType;
        private Iso8601DateTime lastSuccessfulCredentialReset;
        private Iso8601DateTime lastCredentialResetAttempt;
        private Iso8601DateTime lastLogin;
        private AttemptsValue failedLoginAttempts;
        private Iso8601DateTime lastLoginAttempt;
        private CredentialStatusType credentialStatus;
        private List<NotificationChannelTypeValue> otpChannels;
        private InitiatePasswordResetRequest initiatePasswordResetRequest;

        private Builder() {
        }

        public Builder credentialType(String credentialType) {
            this.credentialType = CredentialTypeValue.fromString(credentialType);
            return this;
        }

        public Builder lastSuccessfulCredentialReset(DateTime lastSuccessfulCredentialReset) {
            this.lastSuccessfulCredentialReset = Iso8601DateTime.fromDateTime(lastSuccessfulCredentialReset);
            return this;
        }

        public Builder lastCredentialResetAttempt(DateTime lastCredentialResetAttempt) {
            this.lastCredentialResetAttempt = Iso8601DateTime.fromDateTime(lastCredentialResetAttempt);
            return this;
        }

        public Builder lastLogin(DateTime lastLogin) {
            this.lastLogin = Iso8601DateTime.fromDateTime(lastLogin);
            return this;
        }

        public Builder failedLoginAttempts(int failedLoginAttempts) {
            this.failedLoginAttempts = AttemptsValue.fromInteger(failedLoginAttempts);
            return this;
        }

        public Builder lastLoginAttempt(DateTime lastLoginAttempt) {
            this.lastLoginAttempt = Iso8601DateTime.fromDateTime(lastLoginAttempt);
            return this;
        }

        public Builder credentialStatus(String credentialStatus) {
            this.credentialStatus = Strings.isNullOrEmpty(credentialStatus) ? null : CredentialStatusType.valueOf(credentialStatus);
            return this;
        }

        public Builder initiatePasswordResetRequest(InitiatePasswordResetRequest initiatePasswordResetRequest) {
            this.initiatePasswordResetRequest = initiatePasswordResetRequest;
            return this;
        }

        public Builder otpChannels(List<String> otpChannels) {
            this.otpChannels = otpChannels.stream().map(channel -> NotificationChannelTypeValue.fromString(channel)).collect(Collectors.toList());
            return this;
        }

        public InitiatePasswordResetApprovalRequest build() {
            return Validation.validate(new InitiatePasswordResetApprovalRequest(this));
        }
    }
}

