/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_1.activation;

import com.ericsson.em.m3if.security.v1_0.common.SecurityQuestionAnswer;
import com.ericsson.em.m3if.v1_0.common.ActivationCredential;
import com.ericsson.em.m3if.v1_0.common.BankDomainNameValue;
import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.InvitationTokenValue;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_1", name="activationrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_1", name="", propOrder={"identity", "credentials", "securityQuestionAnswers", "bankDomainName", "currency", "invitationToken"})
public class ActivationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Valid
    @XmlElement(name="identity", type=IdentityValue.class, required=true)
    private IdentityValue identity;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="credentials")
    @XmlElements(value={@XmlElement(name="credential", type=ActivationCredential.class)})
    private List<ActivationCredential> credentials = new LinkedList<ActivationCredential>();
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="securityquestionanswers")
    @XmlElements(value={@XmlElement(name="securityquestionanswer", type=SecurityQuestionAnswer.class)})
    private List<SecurityQuestionAnswer> securityQuestionAnswers;
    @Valid
    @XmlElement(name="bankdomainname", type=BankDomainNameValue.class)
    private BankDomainNameValue bankDomainName;
    @Valid
    @XmlElement(name="currency", type=CurrencyCode.class)
    private CurrencyCode currency;
    @Valid
    @XmlElement(name="invitationtoken", type=InvitationTokenValue.class)
    private InvitationTokenValue invitationToken;

    public ActivationRequest(IdentityValue identity) {
        this.identity = identity;
    }

    public ActivationRequest(IdentityValue identity, BankDomainNameValue bankDomainName, CurrencyCode currency) {
        this.identity = identity;
        this.bankDomainName = bankDomainName;
        this.currency = currency;
    }

    public ActivationRequest() {
        this.identity = null;
    }

    public List<ActivationCredential> getCredentials() {
        return this.credentials;
    }

    public void addCredential(ActivationCredential activationCredential) {
        this.credentials.add(activationCredential);
    }

    public void setCredentials(List<ActivationCredential> credentials) {
        this.credentials = credentials;
    }

    public void setCredential(ActivationCredential credential) {
        this.credentials.add(credential);
    }

    public IdentityValue getIdentity() {
        return this.identity;
    }

    public void setIdentity(IdentityValue identity) {
        this.identity = identity;
    }

    public BankDomainNameValue getBankDomainName() {
        return this.bankDomainName;
    }

    public void setBankDomainName(BankDomainNameValue bankDomainName) {
        this.bankDomainName = bankDomainName;
    }

    public CurrencyCode getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyCode currency) {
        this.currency = currency;
    }

    public List<SecurityQuestionAnswer> getSecurityQuestionAnswers() {
        return this.securityQuestionAnswers;
    }

    public void setSecurityQuestionAnswers(List<SecurityQuestionAnswer> securityQuestionAnswers) {
        this.securityQuestionAnswers = securityQuestionAnswers;
    }

    public InvitationTokenValue getInvitationToken() {
        return this.invitationToken;
    }

    public void setInvitationToken(InvitationTokenValue invitationToken) {
        this.invitationToken = invitationToken;
    }

    public Currency getCurrencyInstance() {
        return this.currency != null ? Currency.getInstance(this.currency.getCode()) : null;
    }
}

