/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_4.common;

import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.provisioning.v1_2.common.AccountStatus;
import com.ericsson.em.m3if.v1_0.common.AccountDescriptionValue;
import com.ericsson.em.m3if.v1_0.common.AccountType;
import com.ericsson.em.m3if.v1_0.common.BankDomainNameValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.ProfileName;
import com.ericsson.em.m3if.v1_1.common.OverdraftValue;
import com.ericsson.em.validators.IsAmount;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_4/common", name="accountdetailstype", propOrder={"fri", "status", "type", "profileName", "referenceProfileName", "balance", "committedBalance", "totalReservation", "totalPositiveReservation", "description", "bankDomainName", "lastActivityTime", "overdraft", "quotaLimit", "quotaBalanceWithoutReserved", "quotaBalanceWithReserved"})
public class AccountDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Valid
    @XmlElement(name="fri", type=FRIValue.class, required=true)
    private FRIValue fri;
    @Valid
    @XmlElement(name="accountstatus")
    private AccountStatus status;
    @NotNull
    @Valid
    @XmlElement(name="accounttype", required=true)
    private AccountType type;
    @Valid
    @XmlElement(name="profilename", type=ProfileName.class)
    private ProfileName profileName;
    @Valid
    @XmlElement(name="referenceprofilename", type=ProfileName.class)
    private ProfileName referenceProfileName;
    @Valid
    @XmlElement(name="balance")
    @IsPositiveAmount
    private MoneyDetails balance;
    @XmlElement(name="committedbalance", type=MoneyDetails.class)
    @Valid
    @IsPositiveAmount
    private MoneyDetails committedBalance;
    @Valid
    @XmlElement(name="totalreservation", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails totalReservation;
    @Valid
    @XmlElement(name="totalpositivereservation", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails totalPositiveReservation;
    @Valid
    @XmlElement(name="description", type=AccountDescriptionValue.class)
    private AccountDescriptionValue description;
    @Valid
    @XmlElement(name="bankdomainname", type=BankDomainNameValue.class)
    private BankDomainNameValue bankDomainName;
    @XmlSchemaType(name="dateTime")
    @XmlElement(name="lastactivitytime")
    private XMLGregorianCalendar lastActivityTime;
    @Valid
    @XmlElement(name="overdraft", type=OverdraftValue.class)
    private OverdraftValue overdraft;
    @IsAmount
    @XmlElement(name="quotalimit")
    private BigDecimal quotaLimit;
    @IsAmount
    @XmlElement(name="quotabalancewithoutreserved")
    private BigDecimal quotaBalanceWithoutReserved;
    @IsAmount
    @XmlElement(name="quotabalancewithreserved")
    private BigDecimal quotaBalanceWithReserved;

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType accountType) {
        this.type = accountType;
    }

    public MoneyDetails getBalance() {
        return this.balance;
    }

    public void setBalance(MoneyDetails balance) {
        this.balance = balance;
    }

    public MoneyDetails getCommittedBalance() {
        return this.committedBalance;
    }

    public void setCommittedBalance(MoneyDetails committedBalance) {
        this.committedBalance = committedBalance;
    }

    public MoneyDetails getTotalReservation() {
        return this.totalReservation;
    }

    public void setTotalReservation(MoneyDetails totalReservation) {
        this.totalReservation = totalReservation;
    }

    public MoneyDetails getTotalPositiveReservation() {
        return this.totalPositiveReservation;
    }

    public void setTotalPositiveReservation(MoneyDetails totalPositiveReservation) {
        this.totalPositiveReservation = totalPositiveReservation;
    }

    public FRIValue getFri() {
        return this.fri;
    }

    public void setFri(FRIValue fri) {
        this.fri = fri;
    }

    public ProfileName getProfileName() {
        return this.profileName;
    }

    public void setProfileName(ProfileName profileName) {
        this.profileName = profileName;
    }

    public void setReferenceProfileName(ProfileName referenceProfileName) {
        this.referenceProfileName = referenceProfileName;
    }

    public ProfileName getReferenceProfileName() {
        return this.referenceProfileName;
    }

    public void setDescription(AccountDescriptionValue description) {
        this.description = description;
    }

    public AccountDescriptionValue getDescription() {
        return this.description;
    }

    public BankDomainNameValue getBankDomainName() {
        return this.bankDomainName;
    }

    public void setBankDomainName(BankDomainNameValue bankDomainName) {
        this.bankDomainName = bankDomainName;
    }

    public DateTime getLastActivityTime() {
        return DateHelper.toDateTime(this.lastActivityTime);
    }

    public void setLastActivityTime(DateTime lastactivitytime) {
        this.lastActivityTime = DateHelper.fromDateTime(lastactivitytime);
    }

    public OverdraftValue getOverdraft() {
        return this.overdraft;
    }

    public void setOverdraft(OverdraftValue overdraft) {
        this.overdraft = overdraft;
    }

    public BigDecimal getQuotaLimit() {
        return this.quotaLimit;
    }

    public void setQuotaLimit(BigDecimal quotaLimit) {
        this.quotaLimit = quotaLimit;
    }

    public BigDecimal getQuotaBalanceWithoutReserved() {
        return this.quotaBalanceWithoutReserved;
    }

    public void setQuotaBalanceWithoutReserved(BigDecimal quotaBalanceWithoutReserved) {
        this.quotaBalanceWithoutReserved = quotaBalanceWithoutReserved;
    }

    public BigDecimal getQuotaBalanceWithReserved() {
        return this.quotaBalanceWithReserved;
    }

    public void setQuotaBalanceWithReserved(BigDecimal quotaBalanceWithReserved) {
        this.quotaBalanceWithReserved = quotaBalanceWithReserved;
    }
}

