/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v2_0.registration;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.provisioning.v1_0.common.AdditionalInformation;
import com.ericsson.em.m3if.provisioning.v1_0.common.AliasValue;
import com.ericsson.em.m3if.provisioning.v1_0.common.CompanyInformation;
import com.ericsson.em.m3if.provisioning.v1_0.common.ExternalDocument;
import com.ericsson.em.m3if.provisioning.v1_0.common.RelativeInformation;
import com.ericsson.em.m3if.v1_0.common.DocumentReferenceInformation;
import com.ericsson.em.m3if.v1_0.common.ProviderCategory;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.SecretTextValue;
import com.ericsson.em.validators.IsASCIIToken;
import com.ericsson.em.validators.IsAlias;
import com.ericsson.em.validators.IsBankAccount;
import com.ericsson.em.validators.IsBankCode;
import com.ericsson.em.validators.IsBankDomain;
import com.ericsson.em.validators.IsEmail;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsHomeChargingRegion;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.IsMultiWordString;
import com.ericsson.em.validators.IsProfileName;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsUsername;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotAllEmpty;
import iso.std.iso._20022.tech.xsd.IndividualPerson10;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v2_0", name="registrationrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v2_0", name="", propOrder={"msisdn", "msisdnVerificationCode", "username", "email", "emailVerificationCode", "alias", "accountHolder", "parentAccountHolderId", "bankAccount", "clearingNumber", "profileName", "taxNumber", "taxRegion", "acceptedTCVersion", "securityQuestion", "securityQuestionAnswer", "timeout", "externalId", "bankDomainName", "homeChargingRegionName", "companyInformation", "guardianInformation", "nextOfKinInformation", "externalDocument", "quoteId", "additionalInformation", "notificationMsisdn", "providerCategory", "aliases", "documentReferenceInformationList"})
@NotAllEmpty(properties={"msisdn", "username", "externalId", "email", "alias", "aliases"})
public class RegistrationRequest
implements QuoteRequest,
Serializable {
    private static final long serialVersionUID = 3L;
    @Length(max=16)
    @IsMSISDN
    @XmlElement(name="msisdn")
    private String msisdn;
    @Length(max=64)
    @IsASCIIToken
    @XmlElement(name="msisdnverificationcode")
    private String msisdnVerificationCode;
    @Length(max=64)
    @IsUsername
    @XmlElement(name="username")
    private String username;
    @IsEmail
    @XmlElement(name="email")
    private String email;
    @Length(max=64)
    @IsASCIIToken
    @XmlElement(name="emailverificationcode")
    private String emailVerificationCode;
    @IsAlias
    @XmlElement(name="alias")
    private String alias;
    @Valid
    @XmlElement(name="accountholder")
    private IndividualPerson10 accountHolder;
    @IsIdentity
    @XmlElement(name="parentaccountholderid")
    private String parentAccountHolderId;
    @IsBankAccount
    @XmlElement(name="bankaccount")
    private String bankAccount;
    @IsBankCode
    @XmlElement(name="clearingnumber")
    private String clearingNumber;
    @Length(max=64)
    @IsProfileName
    @XmlElement(name="profilename")
    private String profileName;
    @Length(max=64)
    @IsMultiWordString
    @XmlElement(name="taxnumber")
    private String taxNumber;
    @IsMultiWordString
    @Length(max=64)
    @XmlElement(name="taxregion")
    private String taxRegion;
    @Length(max=16)
    @IsMultiWordString
    @XmlElement(name="acceptedtcversion")
    private String acceptedTCVersion;
    @Length(max=512)
    @IsRestrictedString
    @XmlElement(name="securityquestion")
    private String securityQuestion;
    @Valid
    @XmlElement(name="securityquestionanswer", type=SecretTextValue.class)
    private SecretTextValue securityQuestionAnswer;
    @XmlElement(name="timeout", defaultValue="30")
    private int timeout = 30;
    @Length(max=30)
    @IsExternalReferenceString
    @XmlElement(name="externalid")
    private String externalId;
    @IsBankDomain
    @XmlElement(name="bankdomainname")
    private String bankDomainName;
    @IsHomeChargingRegion
    @Length(max=64)
    @XmlElement(name="homechargingregionname")
    private String homeChargingRegionName;
    @Valid
    @XmlElement(name="companyinformation")
    private CompanyInformation companyInformation;
    @Valid
    @XmlElement(name="guardianinformation")
    private RelativeInformation guardianInformation;
    @Valid
    @XmlElement(name="nextofkininformation")
    private RelativeInformation nextOfKinInformation;
    @Valid
    @XmlElement(name="externaldocument")
    private ExternalDocument externalDocument;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="additionalinformationlist")
    @XmlElements(value={@XmlElement(name="additionalinformation", type=AdditionalInformation.class)})
    private List<AdditionalInformation> additionalInformation;
    @Length(max=16)
    @IsMSISDN
    @XmlElement(name="notificationmsisdn")
    private String notificationMsisdn;
    @Valid
    @XmlElement(name="providercategory")
    private ProviderCategory providerCategory;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="aliases")
    @XmlElements(value={@XmlElement(name="alias", type=AliasValue.class)})
    private List<AliasValue> aliases;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="documentreferenceinformationlist")
    @XmlElements(value={@XmlElement(name="documentreferenceinformation", type=DocumentReferenceInformation.class)})
    private List<DocumentReferenceInformation> documentReferenceInformationList;

    public RegistrationRequest() {
        this.msisdn = null;
    }

    public RegistrationRequest(String msisdn) {
        this.msisdn = msisdn;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public String getMsisdnVerificationCode() {
        return this.msisdnVerificationCode;
    }

    public void setMsisdnVerificationCode(String msisdnVerificationCode) {
        this.msisdnVerificationCode = msisdnVerificationCode;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmailVerificationCode() {
        return this.emailVerificationCode;
    }

    public void setEmailVerificationCode(String emailVerificationCode) {
        this.emailVerificationCode = emailVerificationCode;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public IndividualPerson10 getAccountHolder() {
        return this.accountHolder;
    }

    public void setAccountHolder(IndividualPerson10 accountHolder) {
        this.accountHolder = accountHolder;
    }

    public String getParentAccountHolderId() {
        return this.parentAccountHolderId;
    }

    public void setParentAccountHolderId(String parentAccountHolderId) {
        this.parentAccountHolderId = parentAccountHolderId;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getClearingNumber() {
        return this.clearingNumber;
    }

    public void setClearingNumber(String clearingNumber) {
        this.clearingNumber = clearingNumber;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getTaxNumber() {
        return this.taxNumber;
    }

    public void setTaxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
    }

    public String getTaxRegion() {
        return this.taxRegion;
    }

    public void setTaxRegion(String taxRegion) {
        this.taxRegion = taxRegion;
    }

    public void setAcceptedTCVersion(String acceptedTCVersion) {
        this.acceptedTCVersion = acceptedTCVersion;
    }

    public String getAcceptedTCVersion() {
        return this.acceptedTCVersion;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public SecretTextValue getSecurityQuestionAnswer() {
        return this.securityQuestionAnswer;
    }

    public void setSecurityQuestionAnswer(SecretTextValue securityQuestionAnswer) {
        this.securityQuestionAnswer = securityQuestionAnswer;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setExternalId(String mExternalId) {
        this.externalId = mExternalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getBankDomainName() {
        return this.bankDomainName;
    }

    public void setBankDomainName(String bankDomainName) {
        this.bankDomainName = bankDomainName;
    }

    public String getHomeChargingRegionName() {
        return this.homeChargingRegionName;
    }

    public void setHomeChargingRegionName(String homeChargingRegionName) {
        this.homeChargingRegionName = homeChargingRegionName;
    }

    public CompanyInformation getCompanyInformation() {
        return this.companyInformation;
    }

    public void setCompanyInformation(CompanyInformation companyInformation) {
        this.companyInformation = companyInformation;
    }

    public RelativeInformation getGuardianInformation() {
        return this.guardianInformation;
    }

    public void setGuardianInformation(RelativeInformation guardianInformation) {
        this.guardianInformation = guardianInformation;
    }

    public RelativeInformation getNextOfKinInformation() {
        return this.nextOfKinInformation;
    }

    public void setNextOfKinInformation(RelativeInformation nextOfKinInformation) {
        this.nextOfKinInformation = nextOfKinInformation;
    }

    public ExternalDocument getExternalDocument() {
        return this.externalDocument;
    }

    public void setExternalDocument(ExternalDocument externalDocument) {
        this.externalDocument = externalDocument;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public List<AdditionalInformation> getAdditionalInformation() {
        if (this.additionalInformation == null) {
            this.additionalInformation = new ArrayList<AdditionalInformation>();
        }
        return this.additionalInformation;
    }

    public void setAdditionalInformation(List<AdditionalInformation> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public void setAdditionalInformation(String name, String value) {
        if (name != null) {
            List<AdditionalInformation> aiList = this.getAdditionalInformation();
            Iterator<AdditionalInformation> iterator = aiList.iterator();
            while (iterator.hasNext()) {
                AdditionalInformation ai = iterator.next();
                if (!name.equalsIgnoreCase(ai.getName())) continue;
                if (value != null) {
                    ai.setValue(value);
                } else {
                    iterator.remove();
                }
                return;
            }
            if (value != null) {
                aiList.add(new AdditionalInformation(name, value));
            }
        }
    }

    public String getAdditionalInformation(String name) {
        if (name != null) {
            for (AdditionalInformation ai : this.getAdditionalInformation()) {
                if (!name.equalsIgnoreCase(ai.getName())) continue;
                return ai.getValue();
            }
        }
        return null;
    }

    public String getNotificationMsisdn() {
        return this.notificationMsisdn;
    }

    public void setNotificationMsisdn(String notificationMsisdn) {
        this.notificationMsisdn = notificationMsisdn;
    }

    public void setProviderCategory(ProviderCategory providerCategory) {
        this.providerCategory = providerCategory;
    }

    public ProviderCategory getProviderCategory() {
        return this.providerCategory;
    }

    public List<AliasValue> getAliases() {
        return this.aliases != null ? this.aliases : Collections.emptyList();
    }

    public void setAliases(List<AliasValue> aliases) {
        this.aliases = aliases;
    }

    public Collection<String> getAllAliases() {
        TreeSet<String> allAliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.alias != null && !this.alias.trim().isEmpty()) {
            allAliases.add(this.alias);
        }
        if (this.aliases != null && !this.aliases.isEmpty()) {
            for (AliasValue aliasValue : this.aliases) {
                if (aliasValue.getAlias() == null || aliasValue.getAlias().trim().isEmpty()) continue;
                allAliases.add(aliasValue.getAlias());
            }
        }
        return allAliases;
    }

    public List<DocumentReferenceInformation> getDocumentReferenceInformationList() {
        if (this.documentReferenceInformationList == null) {
            this.documentReferenceInformationList = new ArrayList<DocumentReferenceInformation>();
        }
        return this.documentReferenceInformationList;
    }

    public void setDocumentReferenceInformationList(List<DocumentReferenceInformation> documentReferenceInformationList) {
        this.documentReferenceInformationList = documentReferenceInformationList;
    }
}

