/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v2_3.registration;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.provisioning.v1_0.common.AdditionalInformation;
import com.ericsson.em.m3if.provisioning.v1_0.common.BusinessContactInformation;
import com.ericsson.em.m3if.provisioning.v1_0.common.ExternalDocument;
import com.ericsson.em.m3if.provisioning.v1_0.common.ProtectedIdentityInformation;
import com.ericsson.em.m3if.provisioning.v1_0.common.RelativeInformation;
import com.ericsson.em.m3if.provisioning.v1_1.common.CompanyInformation;
import com.ericsson.em.m3if.security.v1_0.common.SecurityQuestionAnswer;
import com.ericsson.em.m3if.v1_0.common.AcceptedTCVersion;
import com.ericsson.em.m3if.v1_0.common.AccountNumber;
import com.ericsson.em.m3if.v1_0.common.AliasValue;
import com.ericsson.em.m3if.v1_0.common.BankCode;
import com.ericsson.em.m3if.v1_0.common.BankDomainNameValue;
import com.ericsson.em.m3if.v1_0.common.DocumentReferenceInformation;
import com.ericsson.em.m3if.v1_0.common.EmailAddress;
import com.ericsson.em.m3if.v1_0.common.ExternalIdValue;
import com.ericsson.em.m3if.v1_0.common.HomeChargingRegionName;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.MsisdnValue;
import com.ericsson.em.m3if.v1_0.common.ProtectedIdentityStatus;
import com.ericsson.em.m3if.v1_0.common.ProviderCategory;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.RegistrationProfileName;
import com.ericsson.em.m3if.v1_0.common.TaxNumber;
import com.ericsson.em.m3if.v1_0.common.TaxRegion;
import com.ericsson.em.m3if.v1_0.common.Timeout;
import com.ericsson.em.m3if.v1_0.common.UsernameValue;
import com.ericsson.em.m3if.v1_0.common.VerificationCode;
import com.ericsson.em.validators.NoNullElements;
import iso.std.iso._20022.tech.xsd.IndividualPerson10;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v2_3", name="registrationrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v2_3", name="", propOrder={"msisdn", "msisdnVerificationCode", "username", "email", "emailVerificationCode", "alias", "accountHolder", "parentAccountHolderId", "bankAccount", "clearingNumber", "profileName", "taxNumber", "taxRegion", "acceptedTCVersion", "securityQuestionAnswers", "timeout", "externalId", "bankDomainName", "homeChargingRegionName", "companyInformation", "guardianInformation", "nextOfKinInformation", "externalDocument", "quoteId", "additionalInformation", "notificationMsisdn", "providerCategory", "aliases", "documentReferenceInformationList", "notificationEmail", "businessContactInformation", "accountHolderProtectedIdentityStatus", "protectedIdentityInformation"})
public class RegistrationRequest
implements QuoteRequest,
Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="msisdn", type=MsisdnValue.class)
    private MsisdnValue msisdn;
    @Valid
    @XmlElement(name="msisdnverificationcode", type=VerificationCode.class)
    private VerificationCode msisdnVerificationCode;
    @Valid
    @XmlElement(name="username", type=UsernameValue.class)
    private UsernameValue username;
    @Valid
    @XmlElement(name="email", type=EmailAddress.class)
    private EmailAddress email;
    @Valid
    @XmlElement(name="emailverificationcode", type=VerificationCode.class)
    private VerificationCode emailVerificationCode;
    @Valid
    @XmlElement(name="alias", type=AliasValue.class)
    private AliasValue alias;
    @Valid
    @XmlElement(name="accountholder", type=IndividualPerson10.class)
    private IndividualPerson10 accountHolder;
    @Valid
    @XmlElement(name="parentaccountholderid", type=IdentityValue.class)
    private IdentityValue parentAccountHolderId;
    @Valid
    @XmlElement(name="bankaccount", type=AccountNumber.class)
    private AccountNumber bankAccount;
    @Valid
    @XmlElement(name="clearingnumber", type=BankCode.class)
    private BankCode clearingNumber;
    @Valid
    @XmlElement(name="profilename", type=RegistrationProfileName.class)
    private RegistrationProfileName profileName;
    @Valid
    @XmlElement(name="taxnumber", type=TaxNumber.class)
    private TaxNumber taxNumber;
    @Valid
    @XmlElement(name="taxregion", type=TaxRegion.class)
    private TaxRegion taxRegion;
    @Valid
    @XmlElement(name="acceptedtcversion", type=AcceptedTCVersion.class)
    private AcceptedTCVersion acceptedTCVersion;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="securityquestionanswers")
    @XmlElements(value={@XmlElement(name="securityquestionanswer", type=SecurityQuestionAnswer.class)})
    private List<SecurityQuestionAnswer> securityQuestionAnswers;
    @Valid
    @XmlElement(name="timeout", defaultValue="30", type=Timeout.class)
    private Timeout timeout = Timeout.fromString("30");
    @Valid
    @XmlElement(name="externalid", type=ExternalIdValue.class)
    private ExternalIdValue externalId;
    @Valid
    @XmlElement(name="bankdomainname", type=BankDomainNameValue.class)
    private BankDomainNameValue bankDomainName;
    @Valid
    @XmlElement(name="homechargingregionname", type=HomeChargingRegionName.class)
    private HomeChargingRegionName homeChargingRegionName;
    @Valid
    @XmlElement(name="companyinformation", type=CompanyInformation.class)
    private CompanyInformation companyInformation;
    @Valid
    @XmlElement(name="guardianinformation", type=RelativeInformation.class)
    private RelativeInformation guardianInformation;
    @Valid
    @XmlElement(name="nextofkininformation", type=RelativeInformation.class)
    private RelativeInformation nextOfKinInformation;
    @Valid
    @XmlElement(name="externaldocument", type=ExternalDocument.class)
    private ExternalDocument externalDocument;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="additionalinformationlist")
    @XmlElements(value={@XmlElement(name="additionalinformation", type=AdditionalInformation.class)})
    private List<AdditionalInformation> additionalInformation;
    @Valid
    @XmlElement(name="notificationmsisdn", type=MsisdnValue.class)
    private MsisdnValue notificationMsisdn;
    @Valid
    @XmlElement(name="providercategory", type=ProviderCategory.class)
    private ProviderCategory providerCategory;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="aliases")
    @XmlElements(value={@XmlElement(name="alias", type=AliasValue.class)})
    private List<AliasValue> aliases;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="documentreferenceinformationlist")
    @XmlElements(value={@XmlElement(name="documentreferenceinformation", type=DocumentReferenceInformation.class)})
    private List<DocumentReferenceInformation> documentReferenceInformationList;
    @Valid
    @XmlElement(name="notificationemail", type=EmailAddress.class)
    private EmailAddress notificationEmail;
    @Valid
    @XmlElement(name="businesscontactinformation", type=BusinessContactInformation.class)
    private BusinessContactInformation businessContactInformation;
    @Valid
    @XmlElement(name="accountholderprotectedidentitystatus", type=ProtectedIdentityStatus.class)
    private ProtectedIdentityStatus accountHolderProtectedIdentityStatus;
    @Valid
    @XmlElement(name="protectedidentityinformation", type=ProtectedIdentityInformation.class)
    private ProtectedIdentityInformation protectedIdentityInformation;

    public RegistrationRequest() {
        this.msisdn = null;
    }

    public RegistrationRequest(MsisdnValue msisdn) {
        this.msisdn = msisdn;
    }

    public RegistrationRequest(String msisdn) {
        this.msisdn = MsisdnValue.fromString(msisdn);
    }

    public MsisdnValue getMsisdn() {
        return this.msisdn;
    }

    public void setMsisdn(MsisdnValue msisdn) {
        this.msisdn = msisdn;
    }

    public VerificationCode getMsisdnVerificationCode() {
        return this.msisdnVerificationCode;
    }

    public void setMsisdnVerificationCode(VerificationCode msisdnVerificationCode) {
        this.msisdnVerificationCode = msisdnVerificationCode;
    }

    public UsernameValue getUsername() {
        return this.username;
    }

    public void setUsername(UsernameValue username) {
        this.username = username;
    }

    public EmailAddress getEmail() {
        return this.email;
    }

    public void setEmail(EmailAddress email) {
        this.email = email;
    }

    public VerificationCode getEmailVerificationCode() {
        return this.emailVerificationCode;
    }

    public void setEmailVerificationCode(VerificationCode emailVerificationCode) {
        this.emailVerificationCode = emailVerificationCode;
    }

    public AliasValue getAlias() {
        return this.alias;
    }

    public void setAlias(AliasValue alias) {
        this.alias = alias;
    }

    public IndividualPerson10 getAccountHolder() {
        return this.accountHolder;
    }

    public void setAccountHolder(IndividualPerson10 accountHolder) {
        this.accountHolder = accountHolder;
    }

    public IdentityValue getParentAccountHolderId() {
        return this.parentAccountHolderId;
    }

    public void setParentAccountHolderId(IdentityValue parentAccountHolderId) {
        this.parentAccountHolderId = parentAccountHolderId;
    }

    public AccountNumber getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(AccountNumber bankAccount) {
        this.bankAccount = bankAccount;
    }

    public BankCode getClearingNumber() {
        return this.clearingNumber;
    }

    public void setClearingNumber(BankCode clearingNumber) {
        this.clearingNumber = clearingNumber;
    }

    public RegistrationProfileName getProfileName() {
        return this.profileName;
    }

    public void setProfileName(RegistrationProfileName profileName) {
        this.profileName = profileName;
    }

    public TaxNumber getTaxNumber() {
        return this.taxNumber;
    }

    public void setTaxNumber(TaxNumber taxNumber) {
        this.taxNumber = taxNumber;
    }

    public TaxRegion getTaxRegion() {
        return this.taxRegion;
    }

    public void setTaxRegion(TaxRegion taxRegion) {
        this.taxRegion = taxRegion;
    }

    public void setAcceptedTCVersion(AcceptedTCVersion acceptedTCVersion) {
        this.acceptedTCVersion = acceptedTCVersion;
    }

    public AcceptedTCVersion getAcceptedTCVersion() {
        return this.acceptedTCVersion;
    }

    public List<SecurityQuestionAnswer> getSecurityQuestionAnswers() {
        return this.securityQuestionAnswers;
    }

    public void setSecurityQuestionAnswers(List<SecurityQuestionAnswer> securityQuestionAnswers) {
        this.securityQuestionAnswers = securityQuestionAnswers;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }

    public void setExternalId(ExternalIdValue mExternalId) {
        this.externalId = mExternalId;
    }

    public ExternalIdValue getExternalId() {
        return this.externalId;
    }

    public BankDomainNameValue getBankDomainName() {
        return this.bankDomainName;
    }

    public void setBankDomainName(BankDomainNameValue bankDomainName) {
        this.bankDomainName = bankDomainName;
    }

    public HomeChargingRegionName getHomeChargingRegionName() {
        return this.homeChargingRegionName;
    }

    public void setHomeChargingRegionName(HomeChargingRegionName homeChargingRegionName) {
        this.homeChargingRegionName = homeChargingRegionName;
    }

    public CompanyInformation getCompanyInformation() {
        return this.companyInformation;
    }

    public void setCompanyInformation(CompanyInformation companyInformation) {
        this.companyInformation = companyInformation;
    }

    public RelativeInformation getGuardianInformation() {
        return this.guardianInformation;
    }

    public void setGuardianInformation(RelativeInformation guardianInformation) {
        this.guardianInformation = guardianInformation;
    }

    public RelativeInformation getNextOfKinInformation() {
        return this.nextOfKinInformation;
    }

    public void setNextOfKinInformation(RelativeInformation nextOfKinInformation) {
        this.nextOfKinInformation = nextOfKinInformation;
    }

    public ExternalDocument getExternalDocument() {
        return this.externalDocument;
    }

    public void setExternalDocument(ExternalDocument externalDocument) {
        this.externalDocument = externalDocument;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public List<AdditionalInformation> getAdditionalInformation() {
        if (this.additionalInformation == null) {
            this.additionalInformation = new ArrayList<AdditionalInformation>();
        }
        return this.additionalInformation;
    }

    public void setAdditionalInformation(List<AdditionalInformation> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public void setAdditionalInformation(String name, String value) {
        if (name != null) {
            List<AdditionalInformation> aiList = this.getAdditionalInformation();
            Iterator<AdditionalInformation> iterator = aiList.iterator();
            while (iterator.hasNext()) {
                AdditionalInformation ai = iterator.next();
                if (!name.equalsIgnoreCase(ai.getName())) continue;
                if (value != null) {
                    ai.setValue(value);
                } else {
                    iterator.remove();
                }
                return;
            }
            if (value != null) {
                aiList.add(new AdditionalInformation(name, value));
            }
        }
    }

    public String getAdditionalInformation(String name) {
        if (name != null) {
            for (AdditionalInformation ai : this.getAdditionalInformation()) {
                if (!name.equalsIgnoreCase(ai.getName())) continue;
                return ai.getValue();
            }
        }
        return null;
    }

    public MsisdnValue getNotificationMsisdn() {
        return this.notificationMsisdn;
    }

    public void setNotificationMsisdn(MsisdnValue notificationMsisdn) {
        this.notificationMsisdn = notificationMsisdn;
    }

    public EmailAddress getNotificationEmail() {
        return this.notificationEmail;
    }

    public void setNotificationEmail(EmailAddress notificationEmail) {
        this.notificationEmail = notificationEmail;
    }

    public void setProviderCategory(ProviderCategory providerCategory) {
        this.providerCategory = providerCategory;
    }

    public ProviderCategory getProviderCategory() {
        return this.providerCategory;
    }

    public List<AliasValue> getAliases() {
        return this.aliases != null ? this.aliases : Collections.emptyList();
    }

    public void setAliases(List<AliasValue> aliases) {
        this.aliases = aliases;
    }

    public Collection<String> getAllAliases() {
        TreeSet<String> allAliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.alias != null && !this.alias.toString().trim().isEmpty()) {
            allAliases.add(this.alias.toString());
        }
        if (this.aliases != null && !this.aliases.isEmpty()) {
            for (AliasValue aliasValue : this.aliases) {
                if (aliasValue == null || aliasValue.toString() == null || aliasValue.toString().trim().isEmpty()) continue;
                allAliases.add(aliasValue.toString());
            }
        }
        return allAliases;
    }

    public List<DocumentReferenceInformation> getDocumentReferenceInformationList() {
        if (this.documentReferenceInformationList == null) {
            this.documentReferenceInformationList = new ArrayList<DocumentReferenceInformation>();
        }
        return this.documentReferenceInformationList;
    }

    public void setDocumentReferenceInformationList(List<DocumentReferenceInformation> documentReferenceInformationList) {
        this.documentReferenceInformationList = documentReferenceInformationList;
    }

    public BusinessContactInformation getBusinessContactInformation() {
        return this.businessContactInformation;
    }

    public void setBusinessContactInformation(BusinessContactInformation businessContactInformation) {
        this.businessContactInformation = businessContactInformation;
    }

    public Optional<ProtectedIdentityStatus> getAccountHolderProtectedIdentityStatus() {
        return Optional.ofNullable(this.accountHolderProtectedIdentityStatus);
    }

    public void setAccountHolderProtectedIdentityStatus(ProtectedIdentityStatus accountHolderProtectedIdentityStatus) {
        this.accountHolderProtectedIdentityStatus = accountHolderProtectedIdentityStatus;
    }

    public Optional<ProtectedIdentityInformation> getProtectedIdentityInformation() {
        return Optional.ofNullable(this.protectedIdentityInformation);
    }

    public void setProtectedIdentityInformation(ProtectedIdentityInformation protectedIdentityInformation) {
        this.protectedIdentityInformation = protectedIdentityInformation;
    }
}

