/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.reference;

import com.ericsson.em.validation.Validation;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.io.Serializable;

public class AccountReference
implements Serializable {
    @Valid
    @Size(max=256)
    private final @Valid @Size(max=256) String accountId;
    @Valid
    @Size(max=32)
    private final @Valid @Size(max=32) String accountType;
    @Valid
    @Size(max=64)
    private final @Valid @Size(max=64) String accountRefProfileName;
    @Valid
    @Size(max=16)
    private final @Valid @Size(max=16) String accountRole;

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getAccountRefProfileName() {
        return this.accountRefProfileName;
    }

    public String getAccountRole() {
        return this.accountRole;
    }

    AccountReference(Builder builder) {
        this.accountId = builder.accountId;
        this.accountType = builder.accountType;
        this.accountRefProfileName = builder.accountRefProfileName;
        this.accountRole = builder.accountRole;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String accountId;
        private String accountType;
        private String accountRefProfileName;
        private String accountRole;

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder accountRefProfileName(String accountRefProfileName) {
            this.accountRefProfileName = accountRefProfileName;
            return this;
        }

        public Builder accountRole(String accountRole) {
            this.accountRole = accountRole;
            return this;
        }

        public AccountReference build() {
            return Validation.validate(new AccountReference(this));
        }
    }
}

