/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.security.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.EntityId;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/security/v1_0/common", name="securityquestion", propOrder={"id", "text", "isAnswered"})
public class SecurityQuestion
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Valid
    @XmlElement(name="id", type=EntityId.class, required=true)
    private EntityId id;
    @IsRestrictedString
    @NotNull
    @NotBlank
    @XmlElement(name="text", type=String.class, required=true)
    private String text;
    @Valid
    @XmlElement(name="isanswered", type=Boolean.class, defaultValue="false")
    private Boolean isAnswered = false;

    public SecurityQuestion() {
    }

    public SecurityQuestion(EntityId id, String text) {
        this(id, text, false);
    }

    public SecurityQuestion(EntityId id, String text, Boolean isAnswered) {
        this.id = id;
        this.text = text;
        this.isAnswered = isAnswered;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Boolean getAnswered() {
        return this.isAnswered;
    }

    public void setAnswered(Boolean answered) {
        this.isAnswered = answered;
    }

    public EntityId getId() {
        return this.id;
    }

    public void setId(EntityId id) {
        this.id = id;
    }
}

