/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_0.common;

import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.products.v1_0.common.ProductIdValue;
import com.ericsson.em.m3if.products.v1_0.common.ProductOfferingIdValue;
import com.ericsson.em.m3if.serviceprovider.v1_0.common.AdditionalDetail;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.ReferenceIdValue;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/common", name="receiptitem", propOrder={"itemName", "description", "quantity", "amount", "taxes", "reference", "productId", "productOfferingId", "date", "additionalItemDetails"})
public class ReceiptItem
implements Serializable {
    private static final long serialVersionUID = -4317317933169156261L;
    @IsRestrictedString
    @Length(max=128)
    @XmlElement(name="itemname")
    private String itemName;
    @IsMultilineRestrictedString
    @Length(max=256)
    @XmlElement(name="description")
    private String description;
    @IsRestrictedString
    @Length(max=32)
    @XmlElement(name="quantity")
    private String quantity;
    @Valid
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class)
    private MoneyDetails amount;
    @IsRestrictedString
    @Length(max=32)
    @XmlElement(name="taxes")
    private String taxes;
    @Valid
    @XmlElement(name="reference", type=ReferenceIdValue.class)
    private ReferenceIdValue reference;
    @Valid
    @XmlElement(name="productid", type=ProductIdValue.class)
    private ProductIdValue productId;
    @Valid
    @XmlElement(name="productofferingid", type=ProductOfferingIdValue.class)
    private ProductOfferingIdValue productOfferingId;
    @Valid
    @XmlElement(name="date", type=Iso8601DateTime.class)
    private Iso8601DateTime date;
    @Valid
    @NoNullElements
    @Size(max=5)
    @XmlElementWrapper(name="additionalitemdetails")
    @XmlElements(value={@XmlElement(name="additionaldetail", type=AdditionalDetail.class)})
    private @Valid @Size(max=5) List<AdditionalDetail> additionalItemDetails;

    public String toString() {
        String[] attrs = new String[]{this.itemName != null ? "itemName='" + this.itemName + "'" : null, this.description != null ? "description='" + this.description + "'" : null, this.quantity != null ? "quantity='" + this.quantity + "'" : null, this.amount != null ? "amount=" + this.amount : null, this.taxes != null ? "taxes='" + this.taxes + "'" : null, this.reference != null ? "reference=" + this.reference : null, this.productId != null ? "productId=" + this.productId : null, this.productOfferingId != null ? "productOfferingId=" + this.productOfferingId : null, this.date != null ? "date=" + this.date : null, this.additionalItemDetails != null ? "additionalItemDetails=" + this.additionalItemDetails : null};
        return "ReceiptItem{" + Arrays.stream(attrs).filter(Objects::nonNull).collect(Collectors.joining(", ")) + "}";
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getTaxes() {
        return this.taxes;
    }

    public void setTaxes(String taxes) {
        this.taxes = taxes;
    }

    public ReferenceIdValue getReference() {
        return this.reference;
    }

    public void setReference(ReferenceIdValue reference) {
        this.reference = reference;
    }

    public ProductIdValue getProductId() {
        return this.productId;
    }

    public void setProductId(ProductIdValue productId) {
        this.productId = productId;
    }

    public ProductOfferingIdValue getProductOfferingId() {
        return this.productOfferingId;
    }

    public void setProductOfferingId(ProductOfferingIdValue productOfferingId) {
        this.productOfferingId = productOfferingId;
    }

    public Iso8601DateTime getDate() {
        return this.date;
    }

    public void setDate(Iso8601DateTime date) {
        this.date = date;
    }

    public List<AdditionalDetail> getAdditionalItemDetails() {
        return this.additionalItemDetails;
    }

    public void setAdditionalItemDetails(List<AdditionalDetail> additionalItemDetails) {
        this.additionalItemDetails = additionalItemDetails;
    }
}

