/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v2_0.frontend.payment;

import com.ericsson.em.m3if.financial.v1_0.quotation.Assistable;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.ExtensionTypeLength;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.products.v1_0.common.ProductIdValue;
import com.ericsson.em.m3if.products.v1_0.common.ProductOfferingIdValue;
import com.ericsson.em.m3if.v1_0.common.ClientReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.NumberOfRetriesValue;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ReceiverMessageValue;
import com.ericsson.em.m3if.v1_0.common.SenderNoteValue;
import com.ericsson.em.m3if.v1_1.common.UrlValue;
import com.ericsson.em.m3if.v1_3.common.ScheduledTransactionDate;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v2_0/frontend", name="paymentrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v2_0/frontend", name="", propOrder={"referenceId", "sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "scheduled", "extension", "quoteId", "coupon", "maxNumberOfRetries", "includeSenderCharges", "transferType", "productId", "productOfferingId", "callbackUrl"})
public class PaymentRequest
implements Serializable,
QuoteRequest,
Assistable {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="referenceid", type=ClientReferenceIdValue.class)
    private ClientReferenceIdValue referenceId;
    @Valid
    @XmlElement(name="sendingfri", type=FRIValue.class)
    private FRIValue sendingFRI;
    @Valid
    @NotNull
    @XmlElement(name="receivingfri", type=FRIValue.class, required=true)
    private FRIValue receivingFRI;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="sendernote", type=SenderNoteValue.class)
    private SenderNoteValue senderNote;
    @Valid
    @XmlElement(name="receivermessage", type=ReceiverMessageValue.class)
    private ReceiverMessageValue receiverMessage;
    @Valid
    @XmlElement(name="scheduled", type=ScheduledTransactionDate.class)
    private ScheduledTransactionDate scheduled;
    @Valid
    @ExtensionTypeLength(max=3959)
    @XmlElement(name="extension", type=ExtensionType.class)
    private ExtensionType extension;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="coupon", type=FRIValue.class)
    private FRIValue coupon;
    @Valid
    @XmlElement(name="maxnumberofretries", type=NumberOfRetriesValue.class)
    private NumberOfRetriesValue maxNumberOfRetries;
    @Valid
    @XmlElement(name="transfertype", type=TransferType.class)
    private TransferType transferType;
    @Valid
    @XmlElement(name="productid", type=ProductIdValue.class)
    private ProductIdValue productId;
    @Valid
    @XmlElement(name="productofferingid", type=ProductOfferingIdValue.class)
    private ProductOfferingIdValue productOfferingId;
    @Valid
    @XmlElement(name="includesendercharges", defaultValue="false")
    private boolean includeSenderCharges = false;
    @Valid
    @XmlElement(name="callbackurl", type=UrlValue.class)
    private UrlValue callbackUrl;

    public ClientReferenceIdValue getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(ClientReferenceIdValue referenceId) {
        this.referenceId = referenceId;
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public FRIValue getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(FRIValue receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public SenderNoteValue getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(SenderNoteValue senderNote) {
        this.senderNote = senderNote;
    }

    public ReceiverMessageValue getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(ReceiverMessageValue receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public ScheduledTransactionDate getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(ScheduledTransactionDate scheduled) {
        this.scheduled = scheduled;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public FRIValue getCoupon() {
        return this.coupon;
    }

    public void setCoupon(FRIValue coupon) {
        this.coupon = coupon;
    }

    public NumberOfRetriesValue getMaxNumberOfRetries() {
        return this.maxNumberOfRetries;
    }

    public void setMaxNumberOfRetries(NumberOfRetriesValue maxNumberOfRetries) {
        this.maxNumberOfRetries = maxNumberOfRetries;
    }

    public boolean shallIncludeSenderCharges() {
        return this.includeSenderCharges;
    }

    public void includeSenderCharges() {
        this.includeSenderCharges = true;
    }

    public void excludeSenderCharges() {
        this.includeSenderCharges = false;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public ProductIdValue getProductId() {
        return this.productId;
    }

    public void setProductId(ProductIdValue productId) {
        this.productId = productId;
    }

    public ProductOfferingIdValue getProductOfferingId() {
        return this.productOfferingId;
    }

    public void setProductOfferingId(ProductOfferingIdValue productOfferingId) {
        this.productOfferingId = productOfferingId;
    }

    public void setCallbackUrl(UrlValue callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public Optional<UrlValue> getCallbackUrl() {
        return Optional.ofNullable(this.callbackUrl);
    }
}

