/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.common;

import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.v1_0.common.SettlementReverseDepositDetailsStatus;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0/common", name="reversedeposit", propOrder={"id", "settlementId", "transactionId", "transactionTimeStamp", "originalTransactionId", "originalReceivingFRI", "originalAmount", "message", "status", "financialTransactionId", "resolvedAccountFRI", "originalDepositId", "originalDepositSettlementId", "bookingTimeStamp", "lastUpdatedTimeStamp", "failureReason"})
public class SettlementReverseDepositDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @XmlElement(name="id")
    private Long id;
    @Valid
    @NotNull
    @XmlElement(name="settlementid")
    private Long settlementId;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="transactionid")
    private String transactionId;
    @XmlElement(name="transactiontimestamp")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date transactionTimeStamp;
    @IsExternalReferenceString
    @NotBlank
    @XmlElement(name="originaltransactionid")
    private String originalTransactionId;
    @IsFinancialResourceIdentifier
    @XmlElement(name="originalreceivingfri")
    private String originalReceivingFRI;
    @Valid
    @NotNull
    @XmlElement(name="originalamount")
    @IsPositiveAmount
    private MoneyDetails originalAmount;
    @IsRestrictedString
    @XmlElement(name="message")
    private String message;
    @NotNull
    @XmlElement(name="status")
    private SettlementReverseDepositDetailsStatus status;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="financialtransactionid")
    private Long financialTransactionId;
    @IsFinancialResourceIdentifier
    @XmlElement(name="resolvedaccountfri")
    private String resolvedAccountFRI;
    @Valid
    @XmlElement(name="originaldepositid")
    private Long originalDepositId;
    @Valid
    @NotNull
    @XmlElement(name="originaldepositsettlementid")
    private Long originalDepositSettlementId;
    @XmlElement(name="bookingtimestamp")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date bookingTimeStamp;
    @XmlElement(name="lastupdatedtimestamp")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date lastUpdatedTimeStamp;
    @IsFinancialResourceIdentifier
    @XmlElement(name="failurereason")
    private String failureReason;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public Long getSettlementId() {
        return this.settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public DateTime getTransactionTimeStamp() {
        return DateHelper.fromDate(this.transactionTimeStamp);
    }

    public void setTransactionTimeStamp(DateTime transactionTimeStamp) {
        this.transactionTimeStamp = DateHelper.toDate(transactionTimeStamp);
    }

    public String getOriginalTransactionId() {
        return this.originalTransactionId;
    }

    public void setOriginalTransactionId(String originalTransactionId) {
        this.originalTransactionId = originalTransactionId;
    }

    public String getOriginalReceivingFRI() {
        return this.originalReceivingFRI;
    }

    public void setOriginalReceivingFRI(String originalReceivingFRI) {
        this.originalReceivingFRI = originalReceivingFRI;
    }

    public MoneyDetails getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(MoneyDetails originalAmount) {
        this.originalAmount = originalAmount;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SettlementReverseDepositDetailsStatus getStatus() {
        return this.status;
    }

    public void setStatus(SettlementReverseDepositDetailsStatus status) {
        this.status = status;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public String getResolvedAccountFRI() {
        return this.resolvedAccountFRI;
    }

    public void setResolvedAccountFRI(String resolvedAccountFRI) {
        this.resolvedAccountFRI = resolvedAccountFRI;
    }

    public Long getOriginalDepositId() {
        return this.originalDepositId;
    }

    public void setOriginalDepositId(Long originalDepositId) {
        this.originalDepositId = originalDepositId;
    }

    public Long getOriginalDepositSettlementId() {
        return this.originalDepositSettlementId;
    }

    public void setOriginalDepositSettlementId(Long originalDepositSettlementId) {
        this.originalDepositSettlementId = originalDepositSettlementId;
    }

    public DateTime getBookingTimeStamp() {
        return DateHelper.fromDate(this.bookingTimeStamp);
    }

    public void setBookingTimeStamp(DateTime bookingTimeStamp) {
        this.bookingTimeStamp = DateHelper.toDate(bookingTimeStamp);
    }

    public DateTime getLastUpdatedTimeStamp() {
        return DateHelper.fromDate(this.lastUpdatedTimeStamp);
    }

    public void setLastUpdatedTimeStamp(DateTime lastUpdatedTimeStamp) {
        this.lastUpdatedTimeStamp = DateHelper.toDate(lastUpdatedTimeStamp);
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }
}

