/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.depositinstructionresponse;

import com.ericsson.em.m3if.operations.annotations.IdentityTraceAction;
import com.ericsson.em.m3if.operations.annotations.IdentityTraceAsynchronousHint;
import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.v2_0.common.DepositInstructionResult;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsLongString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@IdentityTraceAsynchronousHint(action=IdentityTraceAction.LOG, field="depositInstructionId", grouping="depositinstruction")
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="depositinstructionresponserequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="", propOrder={"status", "depositInstructionId", "bankTransactionId", "transactionTimeStamp", "bookingTimeStamp", "amount"})
@SignedElements(value={"status", "depositinstructionid", "banktransactionid", "amount/amount", "amount/currency"})
public class DepositInstructionResponseRequest {
    @NotNull
    @XmlElement(name="status", required=true)
    private DepositInstructionResult status;
    @NotBlank
    @Length(max=32)
    @IsLongString(allowNegativeValue=false)
    @XmlElement(name="depositinstructionid", required=true)
    private String depositInstructionId;
    @NotBlank
    @Length(max=100)
    @IsExternalTransactionIdString
    @XmlElement(name="banktransactionid", required=true)
    private String bankTransactionId;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="transactiontimestamp", required=true)
    private DateTimeValue transactionTimeStamp;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="bookingtimestamp", required=true)
    private DateTimeValue bookingTimeStamp;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;

    public DepositInstructionResult getStatus() {
        return this.status;
    }

    public void setStatus(DepositInstructionResult status) {
        this.status = status;
    }

    public String getDepositInstructionId() {
        return this.depositInstructionId;
    }

    public void setDepositInstructionId(String depositInstructionId) {
        this.depositInstructionId = depositInstructionId;
    }

    public String getBankTransactionId() {
        return this.bankTransactionId;
    }

    public void setBankTransactionId(String bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    public DateTimeValue getTransactionTimeStamp() {
        return this.transactionTimeStamp;
    }

    public void setTransactionTimeStamp(DateTimeValue transactionTimeStamp) {
        this.transactionTimeStamp = transactionTimeStamp;
    }

    public DateTimeValue getBookingTimeStamp() {
        return this.bookingTimeStamp;
    }

    public void setBookingTimeStamp(DateTimeValue bookingTimeStamp) {
        this.bookingTimeStamp = bookingTimeStamp;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }
}

