/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v2_0.paymentinstruction;

import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.any.paymentinstruction.IPaymentInstructionResponse;
import com.ericsson.em.m3if.settlement.v2_0.common.PaymentInstructionResult;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsLongString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v2_0", name="paymentinstructionresponse")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v2_0", name="", propOrder={"status", "paymentInstructionId", "bankTransactionId", "transactionTimeStamp", "bookingTimeStamp", "amount"})
@SignedElements(value={"status", "paymentinstructionid", "banktransactionid", "amount/amount", "amount/currency"})
public class PaymentInstructionResponse
implements IPaymentInstructionResponse {
    @XmlElement(name="status", required=true)
    @NotNull
    private PaymentInstructionResult status;
    @NotBlank
    @Length(max=32)
    @IsLongString(allowNegativeValue=false)
    @XmlElement(name="paymentinstructionid", required=true)
    private String paymentInstructionId;
    @NotBlank
    @Length(max=100)
    @IsExternalTransactionIdString
    @XmlElement(name="banktransactionid", required=true)
    private String bankTransactionId;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="transactiontimestamp", required=true)
    private DateTimeValue transactionTimeStamp;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="bookingtimestamp", required=true)
    private DateTimeValue bookingTimeStamp;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;

    public PaymentInstructionResponse() {
    }

    public PaymentInstructionResponse(String paymentInstructionId, String bankTransactionId) {
        this.status = PaymentInstructionResult.FAILED;
        this.paymentInstructionId = paymentInstructionId;
        this.bankTransactionId = bankTransactionId;
    }

    public PaymentInstructionResponse(String paymentInstructionId, String bankTransactionId, DateTimeValue transactionTimeStamp, DateTimeValue bookingTimeStamp, MoneyDetails amount) {
        this.status = PaymentInstructionResult.SUCCESS;
        this.paymentInstructionId = paymentInstructionId;
        this.bankTransactionId = bankTransactionId;
        this.transactionTimeStamp = transactionTimeStamp;
        this.bookingTimeStamp = bookingTimeStamp;
        this.amount = amount;
    }

    @Override
    public PaymentInstructionResult getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(PaymentInstructionResult status) {
        this.status = status;
    }

    @Override
    public String getPaymentInstructionId() {
        return this.paymentInstructionId;
    }

    @Override
    public void setPaymentInstructionId(String paymentInstructionId) {
        this.paymentInstructionId = paymentInstructionId;
    }

    @Override
    public String getBankTransactionId() {
        return this.bankTransactionId;
    }

    @Override
    public void setBankTransactionId(String bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    @Override
    public DateTimeValue getTransactionTimeStamp() {
        return this.transactionTimeStamp;
    }

    @Override
    public void setTransactionTimeStamp(DateTimeValue transactionTimeStamp) {
        this.transactionTimeStamp = transactionTimeStamp;
    }

    @Override
    public DateTimeValue getBookingTimeStamp() {
        return this.bookingTimeStamp;
    }

    @Override
    public void setBookingTimeStamp(DateTimeValue bookingTimeStamp) {
        this.bookingTimeStamp = bookingTimeStamp;
    }

    @Override
    public MoneyDetails getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    @Override
    public String getBankInstructionId() {
        return this.getPaymentInstructionId();
    }

    @Override
    public void setBankInstructionId(String instructionId) {
        this.setPaymentInstructionId(instructionId);
    }
}

