/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.IsAmount;
import com.google.common.base.Objects;
import jakarta.validation.ValidationException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="amount")
public final class AmountValue
implements Serializable,
ValueObject {
    public static final AmountValue ZERO = AmountValue.from(BigDecimal.ZERO).get();
    private static final long serialVersionUID = -2291060037855002201L;
    @XmlValue
    @IsAmount(allowNull=false, allowZero=true)
    private final BigDecimal value;

    public AmountValue() {
        this(null);
    }

    private AmountValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public String getValueAsString() {
        return this.value.toString();
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmountValue amountValue1 = (AmountValue)o;
        return Objects.equal(this.value, amountValue1.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "Amount{amount=" + this.value + "}";
    }

    public static Optional<AmountValue> from(BigDecimal amount) {
        if (amount == null || amount.compareTo(BigDecimal.ZERO) < 0) {
            return Optional.empty();
        }
        return Optional.of(new AmountValue(amount));
    }

    public static AmountValue fromLong(long amount) {
        return Validation.validate(new AmountValue(BigDecimal.valueOf(amount)));
    }

    public static AmountValue fromDouble(double amount) {
        return Validation.validate(new AmountValue(BigDecimal.valueOf(amount)));
    }

    public static AmountValue fromBigDecimal(BigDecimal amount) {
        return Validation.validate(new AmountValue(amount));
    }

    public static AmountValue fromString(String amount) {
        if (amount == null) {
            throw new ValidationException("amount cannot be null");
        }
        return Validation.validate(new AmountValue(new BigDecimal(amount)));
    }
}

