/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.m3if.v1_0.common.AmountValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MsisdnValue;
import com.ericsson.em.m3if.v1_0.common.NameValue;
import com.ericsson.em.validation.Validation;
import com.google.common.base.Objects;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="contributedcommission", propOrder={"contributorName", "dateTime", "amount", "contributorMsisdn"})
public class ContributedCommission
implements Serializable,
ValueObject {
    private static final long serialVersionUID = -1413785827379820458L;
    @Valid
    @XmlElement(name="contributorname")
    private NameValue contributorName;
    @Valid
    @NotNull
    @XmlElement(name="datetime", required=true)
    private Iso8601DateTime dateTime;
    @Valid
    @NotNull
    @XmlElement(name="amount", required=true)
    private AmountValue amount;
    @Valid
    @NotNull
    @XmlElement(name="contributormsisdn", required=true)
    private MsisdnValue contributorMsisdn;

    public ContributedCommission() {
        this(null, null, null, null);
    }

    public ContributedCommission(NameValue contributorName, Iso8601DateTime dateTime, AmountValue amount, MsisdnValue contributorMsisdn) {
        this.contributorName = contributorName;
        this.dateTime = dateTime;
        this.amount = amount;
        this.contributorMsisdn = contributorMsisdn;
    }

    ContributedCommission(Builder builder) {
        this.contributorName = builder.contributorName;
        this.dateTime = builder.dateTime;
        this.amount = builder.amount;
        this.contributorMsisdn = builder.contributorMsisdn;
    }

    @Override
    public String getValueAsString() {
        return null;
    }

    public Optional<NameValue> getContributorName() {
        return Optional.ofNullable(this.contributorName);
    }

    public Iso8601DateTime getDateTime() {
        return this.dateTime;
    }

    public AmountValue getAmount() {
        return this.amount;
    }

    public MsisdnValue getContributorMsisdn() {
        return this.contributorMsisdn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContributedCommission)) {
            return false;
        }
        ContributedCommission that = (ContributedCommission)o;
        return Objects.equal(this.contributorName, that.contributorName) && Objects.equal(this.dateTime, that.dateTime) && Objects.equal(this.amount, that.amount) && Objects.equal(this.contributorMsisdn, that.contributorMsisdn);
    }

    public int hashCode() {
        return Objects.hashCode(this.contributorName, this.dateTime, this.amount, this.contributorMsisdn);
    }

    public String toString() {
        return "ContributedCommission{contributorName=" + this.contributorName + ", dateTime=" + this.dateTime + ", amount=" + this.amount + ", contributorMsisdn=" + this.contributorMsisdn + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @XmlTransient
        private NameValue contributorName;
        @XmlTransient
        private Iso8601DateTime dateTime;
        @XmlTransient
        private AmountValue amount;
        @XmlTransient
        private MsisdnValue contributorMsisdn;

        public Builder contributorName(NameValue contributorName) {
            this.contributorName = contributorName;
            return this;
        }

        public Builder dateTime(Iso8601DateTime dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public Builder amount(AmountValue amount) {
            this.amount = amount;
            return this;
        }

        public Builder contributorMsisdn(MsisdnValue contributorMsisdn) {
            this.contributorMsisdn = contributorMsisdn;
            return this;
        }

        public ContributedCommission build() {
            return Validation.validate(new ContributedCommission(this));
        }
    }
}

