/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.Iso8601Date;
import jakarta.validation.Valid;
import jakarta.validation.ValidationException;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="dateinterval", propOrder={"startDate", "endDate"})
public class DateInterval
implements Serializable {
    private static final long serialVersionUID = -5584640327807914988L;
    @Valid
    @NotNull
    @XmlElement(name="startdate", type=Iso8601Date.class, required=true)
    private final Iso8601Date startDate;
    @Valid
    @NotNull
    @XmlElement(name="enddate", type=Iso8601Date.class, required=true)
    private final Iso8601Date endDate;

    protected DateInterval() {
        this.startDate = Iso8601Date.fromLocalDate(LocalDate.of(1900, 1, 1));
        this.endDate = Iso8601Date.fromLocalDate(LocalDate.now().plusYears(100L));
    }

    private DateInterval(Iso8601Date startDate, Iso8601Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Iso8601Date getStartDate() {
        return this.startDate;
    }

    public Iso8601Date getEndDate() {
        return this.endDate;
    }

    public static DateInterval fromDefaultValues() {
        return new DateInterval();
    }

    public static DateInterval from(Iso8601Date startDate) {
        return DateInterval.newInstance(startDate, Iso8601Date.now());
    }

    public static DateInterval from(Iso8601Date startDate, Iso8601Date endDate) {
        return DateInterval.newInstance(startDate, endDate);
    }

    private static DateInterval newInstance(Iso8601Date startDate, Iso8601Date endDate) {
        DateInterval.validateStartDateIsBeforeEndDate(startDate, endDate);
        return new DateInterval(startDate, endDate);
    }

    private static void validateStartDateIsBeforeEndDate(Iso8601Date startDate, Iso8601Date endDate) {
        if (startDate.getValueAsLocalDate().isAfter(endDate.getValueAsLocalDate())) {
            throw new ValidationException("Start date cannot be after end date");
        }
    }

    public void validateUnmarshalledStartDateIsBeforeEndDate() throws ValidationException {
        DateInterval.validateStartDateIsBeforeEndDate(this.startDate, this.endDate);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateInterval that = (DateInterval)other;
        return Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate);
    }

    public String toString() {
        return "DateInterval{startDate=" + this.startDate + ", endDate=" + this.endDate + "}";
    }
}

