/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import jakarta.validation.Valid;
import jakarta.validation.ValidationException;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="datetimeinterval", propOrder={"startDateTime", "endDateTime"})
public class DateTimeInterval
implements Serializable {
    private static final long serialVersionUID = -5584640327807914988L;
    @Valid
    @NotNull
    @XmlElement(name="startdatetime", type=Iso8601DateTime.class, required=true)
    private final Iso8601DateTime startDateTime;
    @Valid
    @NotNull
    @XmlElement(name="enddatetime", type=Iso8601DateTime.class, required=true)
    private final Iso8601DateTime endDateTime;

    protected DateTimeInterval() {
        this.startDateTime = Iso8601DateTime.fromZonedDateTime(ZonedDateTime.of(1900, 1, 1, 0, 0, 0, 0, ZoneId.systemDefault()));
        this.endDateTime = Iso8601DateTime.fromZonedDateTime(ZonedDateTime.now());
    }

    private DateTimeInterval(Iso8601DateTime startDateTime, Iso8601DateTime endDateTime) {
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
    }

    public Iso8601DateTime getStartDateTime() {
        return this.startDateTime;
    }

    public Iso8601DateTime getEndDateTime() {
        return this.endDateTime;
    }

    public static DateTimeInterval fromDefaultValues() {
        return new DateTimeInterval();
    }

    public static DateTimeInterval from(Iso8601DateTime startDateTime) {
        return DateTimeInterval.newInstance(startDateTime, Iso8601DateTime.fromZonedDateTime(ZonedDateTime.now()));
    }

    public static DateTimeInterval from(Iso8601DateTime startDateTime, Iso8601DateTime endDateTime) {
        return DateTimeInterval.newInstance(startDateTime, endDateTime);
    }

    private static DateTimeInterval newInstance(Iso8601DateTime startDateTime, Iso8601DateTime endDateTime) {
        DateTimeInterval.validateStartIsAfterEnd(startDateTime, endDateTime);
        return new DateTimeInterval(startDateTime, endDateTime);
    }

    private static void validateStartIsAfterEnd(Iso8601DateTime startDateTime, Iso8601DateTime endDateTime) {
        if (startDateTime.getValueAsZonedDateTime().isAfter(endDateTime.getValueAsZonedDateTime())) {
            throw new ValidationException("Start date cannot be after end date");
        }
    }

    public void validateUnmarshalledStartDateIsAfterEndDate() throws ValidationException {
        DateTimeInterval.validateStartIsAfterEnd(this.startDateTime, this.endDateTime);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateTimeInterval that = (DateTimeInterval)other;
        return Objects.equals(this.startDateTime, that.startDateTime) && Objects.equals(this.endDateTime, that.endDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.startDateTime, this.endDateTime);
    }

    public String toString() {
        return "DateTimeInterval{startDateTime=" + this.startDateTime + ", endDateTime=" + this.endDateTime + "}";
    }
}

