/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.validators.IsAmount;
import com.ericsson.em.validators.IsCurrencyCode;
import com.ericsson.lwac.utilities.Preconditions;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="moneydetailstype", propOrder={"amount", "currency"})
public class MoneyDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="amount", required=true)
    @IsAmount(allowNull=false, allowZero=true)
    private BigDecimal amount;
    @XmlElement(name="currency", required=true)
    @IsCurrencyCode
    @NotNull
    private String currency;

    public MoneyDetails() {
    }

    public MoneyDetails(BigDecimal amount, Currency currency) {
        this.amount = amount.setScale(currency.getDefaultFractionDigits() == -1 ? 0 : currency.getDefaultFractionDigits(), RoundingMode.UNNECESSARY);
        this.currency = currency.getCurrencyCode();
    }

    public MoneyDetails(BigDecimal amount, String currency) {
        this.amount = amount;
        this.currency = currency;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public static MoneyDetails valueOf(BigDecimal amount, Currency currency) {
        Preconditions.assertNotNull(amount);
        Preconditions.assertNotNull(currency);
        if (currency.getDefaultFractionDigits() != -1 && amount.scale() > currency.getDefaultFractionDigits()) {
            throw new IllegalArgumentException(String.format("Amount cannot be exactly represented as a MoneyDetails. The currency SEK has maximum 2 fraction digits but the amount (1.00000) has 5.", currency.getCurrencyCode(), currency.getDefaultFractionDigits(), amount, amount.scale()));
        }
        return new MoneyDetails(amount, currency);
    }

    public static MoneyDetails valueOf(BigDecimal amount, String currencyString) {
        Preconditions.assertNotNull(amount);
        Preconditions.assertNotNull(currencyString);
        if ("LOY".equals(currencyString)) {
            if (amount.scale() < 0 || amount.scale() > 0) {
                throw new IllegalArgumentException("Amount must use scale 0");
            }
            return new MoneyDetails(amount, currencyString);
        }
        Currency currency = Currency.getInstance(currencyString);
        if (currency.getDefaultFractionDigits() != -1 && (amount.scale() < 0 || amount.scale() > currency.getDefaultFractionDigits())) {
            throw new IllegalArgumentException("Amount must use scale " + currency.getDefaultFractionDigits());
        }
        return new MoneyDetails(amount, currency);
    }

    public static MoneyDetails valueOf(String amountString, Currency currency) {
        Preconditions.assertNotNull(amountString);
        Preconditions.assertNotNull(currency);
        BigDecimal amount = new BigDecimal(amountString);
        return MoneyDetails.valueOf(amount, currency);
    }

    public static MoneyDetails valueOf(String amountString, String currencyString) {
        Preconditions.assertNotNull(amountString);
        Preconditions.assertNotNull(currencyString);
        BigDecimal amount = new BigDecimal(amountString);
        return MoneyDetails.valueOf(amount, currencyString);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.currency == null ? 0 : this.currency.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneyDetails other = (MoneyDetails)obj;
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        return !(this.currency == null ? other.currency != null : !this.currency.equals(other.currency));
    }

    public MoneyDetails(BigDecimal amount, CurrencyCode currency) {
        this.amount = amount;
        this.currency = currency.getCode();
    }

    public MoneyDetails(MoneyDetails money) {
        this.amount = money.toBigDecimal();
        this.currency = money.getCurrency();
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal toBigDecimal() {
        return this.amount;
    }

    public String toFullString() {
        return String.format("%s %s", this.amount.toPlainString(), this.currency);
    }

    public String toString() {
        return this.amount.toString();
    }
}

