/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.validators.IsIntegerStringWithinRange;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="occurrencesvalue")
public class OccurrencesValue
implements Comparable<OccurrencesValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    @IsIntegerStringWithinRange(min=1, max=999)
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected OccurrencesValue() {
        this.value = null;
    }

    private OccurrencesValue(String value) {
        this.value = value;
    }

    public static OccurrencesValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new OccurrencesValue(value);
    }

    public static OccurrencesValue fromInt(int value) {
        return new OccurrencesValue(String.valueOf(value));
    }

    public String getValueAsString() {
        return this.value;
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.value);
    }

    public static Optional<String> asString(OccurrencesValue frequencyValue) {
        if (frequencyValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(frequencyValue.getValueAsString());
    }

    public static Optional<Integer> asInteger(OccurrencesValue frequencyValue) {
        if (frequencyValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(frequencyValue.getValueAsInt());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OccurrencesValue other = (OccurrencesValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(OccurrencesValue o) {
        return Integer.compare(this.getValueAsInt(), o.getValueAsInt());
    }
}

