/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.AbstractValueObject;
import com.ericsson.em.validators.IsURL;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="urlwithqueryvalue")
public final class UrlWithQueryValue
extends AbstractValueObject {
    private static final long serialVersionUID = 1L;
    @Length(min=8, max=256)
    @IsURL(allowQuery=true)
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    private UrlWithQueryValue() {
        this.value = null;
    }

    private UrlWithQueryValue(String value) {
        this.value = value;
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public static Optional<String> asString(UrlWithQueryValue value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(value.getValueAsString());
    }

    public static UrlWithQueryValue fromString(String value) {
        return value == null ? null : new UrlWithQueryValue(value);
    }
}

