/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validation;

import com.ericsson.em.validation.UrlClassPathResourceMessageInterpolator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public enum Validation {
    INSTANCE;

    private final transient ValidatorFactory factory;
    private final transient Validator validator;

    private Validation() {
        HibernateValidatorConfiguration configure = (HibernateValidatorConfiguration)jakarta.validation.Validation.byProvider(HibernateValidator.class).configure();
        configure.messageInterpolator(new UrlClassPathResourceMessageInterpolator());
        configure.failFast(false);
        this.factory = configure.buildValidatorFactory();
        this.validator = this.factory.getValidator();
    }

    public static <T> T validate(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            INSTANCE.doValidateList((List)value);
        } else if (value instanceof Map) {
            INSTANCE.doValidateMap((Map)value);
        } else if (value instanceof Object[]) {
            INSTANCE.doValidateArray((Object[])value);
        }
        INSTANCE.doValidate(value);
        return value;
    }

    public static <T> boolean isValid(T value) {
        try {
            Validation.validate(value);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private void doValidateList(List<?> list) {
        for (Object element : list) {
            Validation.validate(element);
        }
    }

    private void doValidateMap(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Validation.validate(entry.getKey());
            Validation.validate(entry.getValue());
        }
    }

    private void doValidateArray(Object[] array) {
        for (Object item : array) {
            Validation.validate(item);
        }
    }

    private <T> void doValidate(T value) {
        Set<ConstraintViolation<T>> violations = this.validator.validate(value, new Class[0]);
        if (!violations.isEmpty()) {
            ArrayList<ConstraintViolation<T>> sortedViolations = Lists.newArrayList(violations);
            Collections.sort(sortedViolations, new Comparator<ConstraintViolation<T>>(){

                @Override
                public int compare(ConstraintViolation<T> o1, ConstraintViolation<T> o2) {
                    return o1.getMessageTemplate().compareTo(o2.getMessageTemplate());
                }
            });
            Iterator iterator = sortedViolations.iterator();
            if (iterator.hasNext()) {
                ConstraintViolation violation = (ConstraintViolation)iterator.next();
                if (violation.getInvalidValue() == null) {
                    Path.Node last = Iterables.getLast(violation.getPropertyPath());
                    throw new ValidationException(last.getName() + " " + violation.getMessage());
                }
                Path.Node last = Iterables.getLast(violation.getPropertyPath());
                Class<?> classOfLeafBean = violation.getLeafBean().getClass();
                throw new ValidationException(last.getName() + " in " + classOfLeafBean.getSimpleName() + " is invalid, " + violation.getMessage());
            }
        }
    }
}

