/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsCurrencyCode;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsCurrencyValidator
implements ConstraintValidator<IsCurrencyCode, String> {
    private static final Logger logger;
    private static final Set<String> validCurrencies;

    @Override
    public void initialize(IsCurrencyCode constraintAnnotation) {
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext arg1) {
        if (value == null) {
            return true;
        }
        return validCurrencies.contains(value);
    }

    static {
        HashSet<String> currencies;
        block15: {
            logger = LoggerFactory.getLogger(IsCurrencyValidator.class);
            currencies = new HashSet<String>();
            try (InputStream inputStream = IsCurrencyValidator.class.getResourceAsStream("/currency.properties");){
                if (inputStream == null) break block15;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        if (line.isEmpty() || line.startsWith("#") || line.startsWith("!")) continue;
                        String[] parts = line.split(",");
                        String[] key = parts[0].split("=");
                        currencies.add(key[1]);
                    }
                }
            }
            catch (IOException x) {
                logger.warn("Failed reading /currency.properties", x);
            }
        }
        for (Currency currency : Currency.getAvailableCurrencies()) {
            currencies.add(currency.getCurrencyCode());
        }
        validCurrencies = Collections.unmodifiableSet(currencies);
    }
}

