/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint.entity;

import com.ericsson.ere.constraint.entity.ConstraintContextItem;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ConstraintContext
implements Comparable<ConstraintContext> {
    public static final ConstraintContext EMPTY_CONTEXT = new ConstraintContext();
    public static final ConstraintContext ANY_CONTEXT = ConstraintContext.createConstraintContextForAnyContext();
    private Map<ConstraintContextItemType, ConstraintContextItem> myContextItemMap = new HashMap<ConstraintContextItemType, ConstraintContextItem>();
    private int myGeneralLevel = 0;
    private boolean myIsApplicableToAnyContext = false;
    public static final String ALL_ANY = "*";

    private static ConstraintContext createConstraintContextForAnyContext() {
        ConstraintContext anyContext = new ConstraintContext();
        anyContext.myIsApplicableToAnyContext = true;
        anyContext.myGeneralLevel = 1000;
        return anyContext;
    }

    private ConstraintContext() {
    }

    private void addContext(ConstraintContextItemType type, String name) {
        ConstraintContextItem item = ConstraintContextItem.createContextItem(type, name);
        this.myContextItemMap.put(type, item);
        if (item.isAny()) {
            ++this.myGeneralLevel;
        }
    }

    @Deprecated
    public boolean isEmpty() {
        return this.isEmptyContext();
    }

    public boolean isEmptyContext() {
        return this.myContextItemMap.isEmpty() && !this.myIsApplicableToAnyContext;
    }

    public boolean isAnyContext() {
        return this.myIsApplicableToAnyContext;
    }

    public boolean matches(ConstraintContext otherConstraintContext) {
        if (this.isAnyContext() || otherConstraintContext.isAnyContext()) {
            return true;
        }
        if (this.myContextItemMap.size() == otherConstraintContext.myContextItemMap.size()) {
            for (Map.Entry<ConstraintContextItemType, ConstraintContextItem> currentContext : this.myContextItemMap.entrySet()) {
                ConstraintContextItem otherName = otherConstraintContext.myContextItemMap.get((Object)currentContext.getKey());
                if (otherName != null && (otherName.isAny() || otherName.equals(currentContext.getValue()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Map<ConstraintContextItemType, ConstraintContextItem> getContextMap() {
        return Collections.unmodifiableMap(this.myContextItemMap);
    }

    public ConstraintContextItem itemForType(ConstraintContextItemType type) {
        return this.myContextItemMap.get((Object)type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myContextItemMap == null ? 0 : this.myContextItemMap.hashCode());
        result = 31 * result + (this.myIsApplicableToAnyContext ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintContext other = (ConstraintContext)obj;
        if (this.myContextItemMap == null ? other.myContextItemMap != null : !this.myContextItemMap.equals(other.myContextItemMap)) {
            return false;
        }
        return this.myIsApplicableToAnyContext == other.myIsApplicableToAnyContext;
    }

    @Override
    public int compareTo(ConstraintContext o) {
        return o.myGeneralLevel - this.myGeneralLevel;
    }

    public String toString() {
        return this.describe(Locale.US);
    }

    public String describe(Locale locale) {
        if (this.isEmptyContext()) {
            return "";
        }
        if (this.isAnyContext()) {
            return "everywhere";
        }
        StringBuilder name = new StringBuilder();
        boolean first = true;
        for (Map.Entry<ConstraintContextItemType, ConstraintContextItem> entry : this.myContextItemMap.entrySet()) {
            if (!first) {
                name.append(" and ");
            }
            first = false;
            name.append(entry.getKey().getName()).append(" is ");
            String item = entry.getValue().toString();
            if (!entry.getValue().isAny()) {
                name.append(String.format("'%s'", item));
                continue;
            }
            name.append(item);
        }
        return name.toString();
    }

    public static class Builder {
        private ConstraintContext myContext = new ConstraintContext();

        public Builder addContext(ConstraintContextItemType type, String name) {
            if (type == null || name == null) {
                throw new IllegalArgumentException("Parameter cannot be null");
            }
            if (this.myContext.myContextItemMap.containsKey((Object)type)) {
                throw new IllegalArgumentException("The ConstraintContextType " + (Object)((Object)type) + " already exists in the ConstraintContext");
            }
            this.myContext.addContext(type, name);
            return this;
        }

        public ConstraintContext build() {
            return this.myContext;
        }
    }
}

