/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.dataset.ComplexKey;

public class Key
implements Comparable<Key> {
    private int myIndex = -1;
    private Object myKey = null;
    private static final int MAX_CONSTANT = 16;
    private static Key[] myCachedIndexKeys = new Key[17];

    private Key(int index) {
        this.myIndex = index;
    }

    private Key(Object key) {
        this.myKey = key instanceof Object[] ? ComplexKey.createComplexKeyWithValues((Object[])key) : key;
    }

    public static Key asIndex(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Cannot create Key with index < 0");
        }
        if (i >= 0 && i <= 16) {
            return myCachedIndexKeys[i];
        }
        return new Key(i);
    }

    public static Key asKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Cannot create Key with key null");
        }
        return new Key(key);
    }

    public Object getKey() {
        if (this.myKey == null) {
            throw new IllegalStateException("The key has not been initialized with a key value.");
        }
        return this.myKey;
    }

    public int getIndex() {
        if (this.myIndex < 0) {
            throw new IllegalStateException("The key has not been initialized with an index value.");
        }
        return this.myIndex;
    }

    public boolean containsIndex() {
        return this.myIndex >= 0;
    }

    public boolean containsKey() {
        return this.myKey != null;
    }

    public String toString() {
        if (this.myKey != null) {
            return this.myKey.toString();
        }
        return String.valueOf(this.myIndex);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.myIndex;
        result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Key other = (Key)obj;
        if (this.myIndex != other.myIndex) {
            return false;
        }
        return !(this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey));
    }

    @Override
    public int compareTo(Key o) {
        if (this.containsIndex() && o.containsIndex()) {
            if (this.myIndex == o.myIndex) {
                return 0;
            }
            if (this.myIndex > o.myIndex) {
                return 1;
            }
            return -1;
        }
        if (this.containsKey() && o.containsKey()) {
            if (this.myKey == o.myKey || this.myKey.equals(o.myKey)) {
                return 0;
            }
            return this.myKey.toString().compareTo(o.myKey.toString());
        }
        if (this.containsIndex() && o.containsKey()) {
            return -1;
        }
        return 1;
    }

    static {
        for (int i = 0; i <= 16; ++i) {
            Key.myCachedIndexKeys[i] = new Key(i);
        }
    }
}

