/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.calendar.CalendarDate;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.OperationNotApplicableException;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.datatype.EREDateUtil;
import java.util.Calendar;
import java.util.Date;

@Immutable
public class CalendarDateBasedEREDate
implements EREDate {
    private CalendarDate myCalendarDate;

    private CalendarDateBasedEREDate(CalendarDate cd) {
        this.myCalendarDate = cd;
    }

    private CalendarDateBasedEREDate(int year, int month, int day) {
        this.myCalendarDate = new CalendarDate(year, month, day);
    }

    private CalendarDateBasedEREDate(int daysSinceEpoch) {
        this.myCalendarDate = new CalendarDate(daysSinceEpoch);
    }

    public static CalendarDateBasedEREDate today() {
        Calendar cal = Calendar.getInstance();
        return new CalendarDateBasedEREDate(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public static CalendarDateBasedEREDate forDate(int year, int month, int dayOfMonth) {
        return new CalendarDateBasedEREDate(year, month, dayOfMonth);
    }

    public static CalendarDateBasedEREDate forDaysSinceEpoch(int days) {
        return new CalendarDateBasedEREDate(days);
    }

    @Override
    public Calendar asCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, this.myCalendarDate.getYear());
        cal.set(2, this.myCalendarDate.getMonth() - 1);
        cal.set(5, this.myCalendarDate.getDayOfMonth());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    @Override
    public Date asDate() {
        return this.asCalendar().getTime();
    }

    @Override
    public int compareTo(EREDate other) {
        if (other == this) {
            return 0;
        }
        if (other == BEGINNING_OF_TIME) {
            return 1;
        }
        if (other == END_OF_TIME) {
            return -1;
        }
        return this.getDaysSince19700101() - other.getDaysSince19700101();
    }

    @Override
    public int compareTo(Calendar other) {
        return this.compareTo(EREDateFactory.createFromCalendar(other));
    }

    @Override
    public int compareTo(Date other) {
        return this.compareTo(EREDateFactory.createFromDate(other));
    }

    @Override
    public int daysUntil(EREDate other) {
        if (other == this) {
            return 0;
        }
        if (EREDateUtil.isBoundaryDate(other)) {
            throw new OperationNotApplicableException("Operation is not supported for boundary date constants.");
        }
        return other.getDaysSince19700101() - this.myCalendarDate.getDaysSince19700101();
    }

    @Override
    public int getDayOfMonth() {
        return this.myCalendarDate.getDayOfMonth();
    }

    @Override
    public EREDate.WeekDay getDayOfWeek() {
        return EREDate.WeekDay.getFrom(this.myCalendarDate);
    }

    @Override
    public int getDaysSince19700101() {
        return this.myCalendarDate.getDaysSince19700101();
    }

    @Override
    public int getFullYear() {
        return this.myCalendarDate.getYear();
    }

    @Override
    public int getMonthOfYear() {
        return this.myCalendarDate.getMonth();
    }

    @Override
    public boolean isAfter(EREDate other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public boolean isBefore(EREDate other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public EREDate plusDays(int days) {
        if (days == 0) {
            return this;
        }
        CalendarDate cd = this.myCalendarDate.addDays(days);
        return new CalendarDateBasedEREDate(cd);
    }

    @Override
    public EREDate plusMonths(int months) {
        if (months == 0) {
            return this;
        }
        CalendarDate cd = this.myCalendarDate.addMonths(months);
        return new CalendarDateBasedEREDate(cd);
    }

    @Override
    public EREDate plusYears(int years) {
        if (years == 0) {
            return this;
        }
        CalendarDate cd = this.myCalendarDate.addMonths(years * 12);
        return new CalendarDateBasedEREDate(cd);
    }

    public String toString() {
        return String.format("%04d-%02d-%02d", this.getFullYear(), this.getMonthOfYear(), this.getDayOfMonth());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myCalendarDate == null ? 0 : this.myCalendarDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Date && !(obj instanceof EREDate)) {
            return this.asDate().equals(obj);
        }
        if (!(obj instanceof EREDate)) {
            return false;
        }
        EREDate other = (EREDate)obj;
        return this.compareTo(other) == 0;
    }
}

