/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.dataset.SelectionTreeQualifier;
import com.ericsson.ere.defs.ProfileAlreadyRegisteredSTQException;
import com.ericsson.ere.defs.STQNotFoundException;
import com.ericsson.ere.defs.STQRepository;
import com.ericsson.ere.selectiontree.statements.STQChangeEvent;
import com.ericsson.ere.selectiontree.statements.STQNotificationReceiver;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.interfaces.ClassProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class STQRepositoryImpl
implements STQRepository,
TreeModelListener {
    private Map<SelectionTreeQualifier, Integer> myStqContainer = new HashMap<SelectionTreeQualifier, Integer>();
    private Map<ClassProfile, SelectionTreeQualifier> mySTQForProfileContainer = new HashMap<ClassProfile, SelectionTreeQualifier>();
    private Map<ClassProfile, SelectionTreeQualifier> mySTQForProfileBackup = new WeakHashMap<ClassProfile, SelectionTreeQualifier>();

    @Override
    public boolean exists(SelectionTreeQualifier stq) {
        return this.myStqContainer.containsKey(stq);
    }

    @Override
    public void registerSTQReference(SelectionTreeQualifier stq, ClassProfile profile) {
        if (this.mySTQForProfileContainer.containsKey(profile)) {
            throw new ProfileAlreadyRegisteredSTQException(this.mySTQForProfileContainer.get(profile));
        }
        int newRefCount = 1;
        Integer currentRefCount = this.myStqContainer.get(stq);
        if (currentRefCount != null) {
            newRefCount = currentRefCount + 1;
        }
        this.myStqContainer.put(stq, newRefCount);
        this.mySTQForProfileContainer.put(profile, stq);
        List<STQNotificationReceiver> eventRecevierList = this.findProfilesReferingToSTQ(stq, profile);
        this.notifySTQChange(stq, eventRecevierList, STQChangeEvent.STQChangeType.ADDED);
    }

    @Override
    public void unregisterSTQReference(SelectionTreeQualifier stq, ClassProfile profile) {
        if (!this.mySTQForProfileContainer.containsKey(profile)) {
            return;
        }
        Integer currentRefCount = this.myStqContainer.get(stq);
        if (currentRefCount == null) {
            throw new STQNotFoundException(stq);
        }
        if (currentRefCount == 1) {
            this.myStqContainer.remove(stq);
        } else {
            Integer newRefCount = currentRefCount - 1;
            this.myStqContainer.put(stq, newRefCount);
        }
        this.mySTQForProfileContainer.remove(profile);
        List<STQNotificationReceiver> eventRecevierList = this.findProfilesReferingToSTQ(stq, profile);
        this.notifySTQChange(stq, eventRecevierList, STQChangeEvent.STQChangeType.REMOVED);
    }

    @Override
    public int getReferenceCountFor(SelectionTreeQualifier stq) {
        int resultingRefCount = 0;
        Integer tempResult = this.myStqContainer.get(stq);
        if (tempResult != null) {
            resultingRefCount = tempResult;
        }
        return resultingRefCount;
    }

    @Override
    public SelectionTreeQualifier getSTQFor(ClassProfile profile) {
        return this.mySTQForProfileContainer.get(profile);
    }

    private List<STQNotificationReceiver> findProfilesReferingToSTQ(SelectionTreeQualifier referenceStq, ClassProfile originatingProfile) {
        ArrayList<STQNotificationReceiver> resultProfileList = new ArrayList<STQNotificationReceiver>();
        for (ClassProfile clProfile : this.mySTQForProfileContainer.keySet()) {
            if (!this.mySTQForProfileContainer.get(clProfile).equals(referenceStq) || !(clProfile instanceof STQNotificationReceiver) || clProfile.equals(originatingProfile)) continue;
            resultProfileList.add((STQNotificationReceiver)((Object)clProfile));
        }
        return resultProfileList;
    }

    private void notifySTQChange(SelectionTreeQualifier referenceSTQ, List<STQNotificationReceiver> referencedProfileList, STQChangeEvent.STQChangeType changeType) {
        if (referencedProfileList.size() > 0) {
            STQChangeEvent changeEvent = new STQChangeEvent(this, changeType, referenceSTQ);
            for (STQNotificationReceiver profileReceiver : referencedProfileList) {
                profileReceiver.notifySTQChange(changeEvent);
            }
        }
    }

    @Override
    public boolean isRepositoryEmpty() {
        return this.mySTQForProfileContainer.isEmpty();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.handleAutomaticRegistrationUnregistration(e, true);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.handleAutomaticRegistrationUnregistration(e, false);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    private void handleAutomaticRegistrationUnregistration(TreeModelEvent e, boolean register) {
        TariffDAGModel model = (TariffDAGModel)e.getSource();
        Object[] children = e.getChildren();
        if (children == null) {
            throw new AssertionError((Object)"Unexpected - no elements to register for.");
        }
        for (Object child : children) {
            this.handleAutomaticRegistrationUnregistration(model, (TSElement)child, register);
        }
    }

    private void handleAutomaticRegistrationUnregistration(TariffDAGModel model, TSElement node, boolean register) {
        if (node.isLink()) {
            return;
        }
        ClassProfile profile = node.getClassProfile();
        if (register) {
            this.handleAutomaticRegistration(profile);
        } else {
            this.handleAutomaticUnregistration(profile);
        }
        int cc = model.getChildCount(node);
        for (int i = 0; i < cc; ++i) {
            TSElement child = (TSElement)model.getChild(node, i);
            this.handleAutomaticRegistrationUnregistration(model, child, register);
        }
    }

    private void handleAutomaticUnregistration(ClassProfile profile) {
        SelectionTreeQualifier stq = this.mySTQForProfileContainer.get(profile);
        if (stq != null) {
            this.unregisterSTQReferenceWithBackup(stq, profile);
        }
    }

    private void handleAutomaticRegistration(ClassProfile profile) {
        if (this.profileIsInBackup(profile)) {
            assert (!this.mySTQForProfileContainer.containsKey(profile)) : "Profile is in backup and regular container simultaneously!";
            this.registerSTQReferenceFromBackup(profile);
        }
    }

    private void unregisterSTQReferenceWithBackup(SelectionTreeQualifier stq, ClassProfile profile) {
        this.mySTQForProfileBackup.put(profile, stq);
        this.unregisterSTQReference(stq, profile);
    }

    private boolean profileIsInBackup(ClassProfile profile) {
        return this.mySTQForProfileBackup.containsKey(profile);
    }

    private void registerSTQReferenceFromBackup(ClassProfile profile) {
        SelectionTreeQualifier stq = this.mySTQForProfileBackup.remove(profile);
        assert (stq != null) : "Called with a profile that isn't in the backup.";
        this.registerSTQReference(stq, profile);
    }
}

