/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.defs.ServiceFieldStructure;
import com.ericsson.ere.defs.ServiceFieldValidator;
import ericsson.ere.defs.FieldDefinition;
import java.util.Arrays;
import java.util.List;

public final class ServiceFieldValidators {
    private ServiceFieldValidators() {
    }

    public static ServiceFieldValidator createBasicFieldValidator() {
        ServiceFieldValidator validator = new ServiceFieldValidator();
        validator.addValidator(ServiceFieldStructure.ArrayGroupElement.class, new ArrayGroupFieldTypeValidator());
        validator.addValidator(ServiceFieldStructure.MapGroupElement.class, new MapGroupFieldTypeValidator());
        validator.addValidator(ServiceFieldStructure.MapGroupElement.class, new MapGroupSameKeyFieldsValidator());
        validator.addValidator(ServiceFieldStructure.MapGroupElement.class, new MapGroupAllKeyFieldsValidator());
        validator.addValidator(ServiceFieldStructure.MapGroupElement.class, new MapGroupNoKeyFieldsValidator());
        EmptyFieldGroupValidator emptyFieldGroupValidator = new EmptyFieldGroupValidator();
        validator.addValidator(ServiceFieldStructure.ArrayGroupElement.class, emptyFieldGroupValidator);
        validator.addValidator(ServiceFieldStructure.MapGroupElement.class, emptyFieldGroupValidator);
        return validator;
    }

    static List<String> getKeyFields(ServiceFieldStructure.FieldElement element) {
        return Arrays.asList(element.getField().getKeyFields());
    }

    private static class ArrayGroupFieldTypeValidator
    extends ServiceFieldValidator.AbstractFieldValidator<ServiceFieldStructure.ArrayGroupElement> {
        private ArrayGroupFieldTypeValidator() {
        }

        @Override
        public void validate(ServiceFieldStructure.ArrayGroupElement element) {
            int cc = element.getChildCount();
            for (int i = 0; i < cc; ++i) {
                ServiceFieldStructure.FieldElement fe = (ServiceFieldStructure.FieldElement)element.getChildAt(i);
                FieldDefinition field = fe.getField();
                if (field.isArray()) continue;
                String reason = String.format("Field '%s' was found in array group '%s' but is not an array field.", field.getFieldName(), element.getName());
                this.registerError(new ServiceFieldValidator.FieldValidatorError(fe, reason));
            }
        }
    }

    private static class MapGroupAllKeyFieldsValidator
    extends ServiceFieldValidator.AbstractFieldValidator<ServiceFieldStructure.MapGroupElement> {
        private MapGroupAllKeyFieldsValidator() {
        }

        @Override
        public void validate(ServiceFieldStructure.MapGroupElement element) {
            int cc = element.getChildCount();
            if (cc > 0) {
                ServiceFieldStructure.FieldElement fe0 = (ServiceFieldStructure.FieldElement)element.getChildAt(0);
                List<String> keyFields = ServiceFieldValidators.getKeyFields(fe0);
                for (String keyField : keyFields) {
                    if (element.getNamedChild(keyField) != null) continue;
                    String reason = String.format("Map group '%s' does not contain key field '%s'.", element.getName(), keyField);
                    ServiceFieldValidator.FieldValidatorError error = new ServiceFieldValidator.FieldValidatorError(element, reason);
                    this.registerError(error);
                }
            }
        }
    }

    private static class MapGroupSameKeyFieldsValidator
    extends ServiceFieldValidator.AbstractFieldValidator<ServiceFieldStructure.MapGroupElement> {
        private MapGroupSameKeyFieldsValidator() {
        }

        @Override
        public void validate(ServiceFieldStructure.MapGroupElement element) {
            int cc = element.getChildCount();
            if (cc > 0) {
                ServiceFieldStructure.FieldElement fe0 = (ServiceFieldStructure.FieldElement)element.getChildAt(0);
                List<String> expectedKeyFields = ServiceFieldValidators.getKeyFields(fe0);
                for (int i = 1; i < cc; ++i) {
                    ServiceFieldStructure.FieldElement fe = (ServiceFieldStructure.FieldElement)element.getChildAt(i);
                    List<String> actualKeyFields = ServiceFieldValidators.getKeyFields(fe);
                    if (this.areEqual(expectedKeyFields, actualKeyFields)) continue;
                    String reason = String.format("Field '%s' is in the same map group ('%s') as field '%s', but has different key fields. Expected %s but found %s.", fe.getField().getFieldName(), element.getName(), fe0.getField().getFieldName(), expectedKeyFields, actualKeyFields);
                    ServiceFieldValidator.FieldValidatorError error = new ServiceFieldValidator.FieldValidatorError(fe, reason);
                    this.registerError(error);
                }
            }
        }

        private boolean areEqual(List<String> list1, List<String> list2) {
            boolean eq = false;
            if (list1.size() == list2.size()) {
                eq = list1.containsAll(list2);
            }
            return eq;
        }
    }

    private static class MapGroupNoKeyFieldsValidator
    extends ServiceFieldValidator.AbstractFieldValidator<ServiceFieldStructure.MapGroupElement> {
        private MapGroupNoKeyFieldsValidator() {
        }

        @Override
        public void validate(ServiceFieldStructure.MapGroupElement element) {
            ServiceFieldStructure.FieldElement[] keyFields = element.getKeyFieldElements();
            if (keyFields.length == 0) {
                String reason = String.format("The map group '%s' has no keyField attribute.", element.getName());
                ServiceFieldValidator.FieldValidatorError error = new ServiceFieldValidator.FieldValidatorError(element, reason);
                this.registerError(error);
            }
        }
    }

    private static class EmptyFieldGroupValidator
    extends ServiceFieldValidator.AbstractFieldValidator<ServiceFieldStructure.FieldGroupElement> {
        private EmptyFieldGroupValidator() {
        }

        @Override
        public void validate(ServiceFieldStructure.FieldGroupElement element) {
            int cc = element.getChildCount();
            if (cc == 0) {
                String reason = String.format("The array/map group '%s' is empty, which is disallowed.", element.getName());
                ServiceFieldValidator.FieldValidatorError error = new ServiceFieldValidator.FieldValidatorError(element, reason);
                this.registerError(error);
            }
        }
    }

    private static class MapGroupFieldTypeValidator
    extends ServiceFieldValidator.AbstractFieldValidator<ServiceFieldStructure.MapGroupElement> {
        private MapGroupFieldTypeValidator() {
        }

        @Override
        public void validate(ServiceFieldStructure.MapGroupElement element) {
            int cc = element.getChildCount();
            for (int i = 0; i < cc; ++i) {
                ServiceFieldStructure.FieldElement fe = (ServiceFieldStructure.FieldElement)element.getChildAt(i);
                FieldDefinition field = fe.getField();
                if (field.isMap()) continue;
                String reason = String.format("Field '%s' was found in map group '%s' but is not a map field.", field.getFieldName(), element.getName());
                this.registerError(new ServiceFieldValidator.FieldValidatorError(fe, reason));
            }
        }
    }
}

