/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.expression.BinaryDateOperator;
import com.ericsson.ere.expression.GenericBinaryOperator;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.expression.UnitValue;
import com.ericsson.ere.math.RatingDecimal;

public enum BinaryTimeOperator {
    ADD{

        @Override
        Object perform(Object left, Object right) {
            boolean leftIsTime = 1.isTime(left);
            ERETime time = (ERETime)(leftIsTime ? left : right);
            Object other = leftIsTime ? right : left;
            String otherLocation = leftIsTime ? "right" : "left";
            TimeUnit[] unit = new TimeUnit[1];
            Integer[] value = new Integer[1];
            BinaryTimeOperator.extractUnitAndValue(other, unit, value, otherLocation);
            ERETime ret = this.addToTime(time, value[0], unit[0]);
            return ret;
        }
    }
    ,
    SUBTRACT{

        @Override
        Object perform(Object left, Object right) {
            Object ret;
            boolean bothAreTimes;
            boolean leftIsTime = 2.isTime(left);
            boolean bl = bothAreTimes = leftIsTime && 2.isTime(right);
            if (bothAreTimes) {
                ret = EREDateUtil.calculateEREDateDifference((ERETime)left, (ERETime)right).getDifference();
            } else if (leftIsTime) {
                if (right instanceof EREDate) {
                    ret = EREDateUtil.calculateEREDateDifference((ERETime)left, (EREDate)right).getDifference();
                } else {
                    TimeUnit[] unit = new TimeUnit[1];
                    Integer[] value = new Integer[1];
                    BinaryTimeOperator.extractUnitAndValue(right, unit, value, "right");
                    ret = this.addToTime((ERETime)left, -value[0].intValue(), unit[0]);
                }
            } else {
                throw new IllegalArgumentException("Time subtraction requires the left or both operands to be times.");
            }
            return ret;
        }
    };


    abstract Object perform(Object var1, Object var2);

    private static TimeUnit getTimeUnit(UnitValue<?, ?> uv) {
        Object u = uv.getUnit();
        if (u instanceof BinaryDateOperator.DateUnit) {
            BinaryDateOperator.DateUnit du = (BinaryDateOperator.DateUnit)u;
            switch (du) {
                case DAYS: {
                    u = TimeUnit.DAYS;
                    break;
                }
                case MONTHS: {
                    u = TimeUnit.MONTHS;
                    break;
                }
                case YEARS: {
                    u = TimeUnit.YEARS;
                }
            }
        }
        if (!(u instanceof TimeUnit)) {
            throw new IllegalArgumentException("Unit not a TimeUnit: " + u.getClass().getName());
        }
        return (TimeUnit)u;
    }

    private static void extractUnitAndValue(Object valueObject, TimeUnit[] refUnit, Integer[] refValue, String operandLocation) {
        Object obj = valueObject;
        refUnit[0] = TimeUnit.DAYS;
        if (obj instanceof UnitValue) {
            UnitValue uv = (UnitValue)obj;
            obj = uv.getValue();
            refUnit[0] = BinaryTimeOperator.getTimeUnit(uv);
        }
        RatingDecimal num = GenericBinaryOperator.convertToRatingDecimal(obj, operandLocation);
        refValue[0] = num.intValue();
    }

    static boolean isTime(Object value) {
        return value instanceof ERETime;
    }

    static boolean canHandle(Object left, Object right) {
        return BinaryTimeOperator.isTime(left);
    }

    protected ERETime addToTime(ERETime time, int value, TimeUnit unit) {
        return unit.execute(time, value);
    }

    protected long getTimeDifferenceInSeconds(ERETime time1, ERETime time2) {
        long minuendMsec = time1.getMillisecondsSinceEpoch();
        long subtrahendMsec = time2.getMillisecondsSinceEpoch();
        long diff = minuendMsec - subtrahendMsec;
        return diff / 1000L;
    }

    public static enum TimeUnit implements Unit
    {
        DAYS(6),
        MONTHS(2),
        YEARS(1),
        HOURS(11),
        MINUTES(12),
        SECONDS(13),
        MILLISECONDS(14);

        private int myCalendarField;

        private TimeUnit(int calendarField) {
            this.myCalendarField = calendarField;
        }

        public ERETime execute(ERETime t, int value) {
            ERETime retVal = t;
            switch (this.myCalendarField) {
                case 6: {
                    retVal = (ERETime)t.plusDays(value);
                    break;
                }
                case 2: {
                    retVal = (ERETime)t.plusMonths(value);
                    break;
                }
                case 1: {
                    retVal = (ERETime)t.plusYears(value);
                    break;
                }
                case 11: {
                    retVal = t.plusHours(value);
                    break;
                }
                case 12: {
                    retVal = t.plusMinutes(value);
                    break;
                }
                case 13: {
                    retVal = t.plusSeconds(value);
                    break;
                }
                case 14: {
                    retVal = t.plusMilliseconds(value);
                }
            }
            return retVal;
        }
    }
}

