/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.dataset.DataSetField;
import java.util.Collection;

public interface FieldContainerOperand {
    public Collection<FieldContainer> getContainedFields();

    public static class FieldContainer {
        private final String myName;
        private final Object myKeyObject;
        private final transient DataSetField myField;

        public FieldContainer(String name, Object keyObject) {
            this.myField = null;
            this.myName = name;
            this.myKeyObject = keyObject;
        }

        public FieldContainer(DataSetField field, Object keyObject) {
            this.myField = field;
            this.myName = field.getFieldName();
            this.myKeyObject = keyObject;
        }

        public DataSetField getField() {
            return this.myField;
        }

        public boolean containsField() {
            return this.myField != null;
        }

        public String getFieldName() {
            return this.myName;
        }

        public Object getKeyObject() {
            return this.myKeyObject;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myKeyObject == null ? 0 : this.myKeyObject.hashCode());
            result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldContainer other = (FieldContainer)obj;
            if (this.myKeyObject == null ? other.myKeyObject != null : !this.myKeyObject.equals(other.myKeyObject)) {
                return false;
            }
            return !(this.myName == null ? other.myName != null : !this.myName.equals(other.myName));
        }

        public String toString() {
            return this.myKeyObject == null ? this.myName : this.myName + " (key: " + this.myKeyObject + ")";
        }
    }
}

