/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionEvaluator;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.FieldContainerOperand;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.ValueOperand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class FieldUseEvaluator
implements ExpressionEvaluator {
    private FieldUseEvaluator() {
    }

    @Override
    public Operand evaluate(Expression expr, EvaluationContext context) {
        List<FieldContainerOperand.FieldContainer> fields = this.findFields(expr);
        return ValueOperand.createFor(fields);
    }

    private List<FieldContainerOperand.FieldContainer> findFields(Expression expr) {
        List<FieldContainerOperand.FieldContainer> fields;
        if (expr == null) {
            fields = Collections.emptyList();
        } else {
            HashSet<FieldContainerOperand.FieldContainer> set = new HashSet<FieldContainerOperand.FieldContainer>();
            for (ExpressionToken token : expr.getExpressionTokens()) {
                if (!(token instanceof FieldContainerOperand)) continue;
                FieldContainerOperand op = (FieldContainerOperand)((Object)token);
                set.addAll(op.getContainedFields());
            }
            fields = new ArrayList<FieldContainerOperand.FieldContainer>(set);
        }
        return fields;
    }

    public static List<FieldContainerOperand.FieldContainer> getUsedFields(Expression expression) {
        FieldUseEvaluator eval = new FieldUseEvaluator();
        ValueOperand result = (ValueOperand)eval.evaluate(expression, null);
        return (List)result.getValue(null);
    }
}

