/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression.parser;

import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionFormatter;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.FieldValueOperand;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.Functions;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.expression.UnitOperand;
import com.ericsson.ere.expression.Units;
import com.ericsson.ere.expression.ValueOperand;
import com.ericsson.ere.expression.parser.ExpressionParser;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.util.StringUtil;
import java.util.List;

public class ParseableExpressionFormatter
implements ExpressionFormatter {
    private ClassRepository myRepository;

    public ParseableExpressionFormatter(ClassRepository aRepository) {
        if (aRepository == null) {
            throw new IllegalArgumentException("Repository cannot be null.");
        }
        this.myRepository = aRepository;
    }

    @Override
    public String format(Expression expr) {
        StringBuffer theBuffer = new StringBuffer();
        List<ExpressionToken> theTokens = expr.getExpressionTokens();
        for (ExpressionToken theToken : theTokens) {
            theBuffer.append(this.formatToken(theToken));
        }
        return theBuffer.toString();
    }

    private String formatToken(ExpressionToken theToken) {
        if (theToken instanceof ValueOperand) {
            return this.formatValueOperand((ValueOperand)theToken);
        }
        if (theToken instanceof FieldValueOperand) {
            return this.formatFieldValueOperand((FieldValueOperand)theToken);
        }
        if (theToken instanceof UnitOperand) {
            return this.formatUnitOperand((UnitOperand)theToken);
        }
        if (theToken instanceof Function) {
            return this.formatFunction((Function)theToken);
        }
        if (theToken instanceof Operator) {
            return this.formatOperator((Operator)theToken);
        }
        return theToken.toString();
    }

    private String formatOperator(Operator operator) {
        boolean isKnown = Operators.getOperatorName(operator) != null;
        String name = isKnown ? operator.toString() : "#" + this.getCustomOperatorName(operator) + "#";
        return name;
    }

    private String formatFunction(Function function) {
        return this.getFunctionName(function);
    }

    protected String getCustomOperatorName(Operator operator) {
        throw new UnsupportedOperationException("Must be implemented in a sub class.");
    }

    protected String getFunctionName(Function function) {
        String name = Functions.getFunctionName(function);
        if (name == null) {
            name = "$" + function.getFunctionName();
        }
        return name;
    }

    private String formatUnitOperand(UnitOperand theToken) {
        StringBuilder theBuilder = new StringBuilder();
        theBuilder.append(this.formatToken(theToken.getOperand()));
        theBuilder.append("u{");
        theBuilder.append(Units.getUnitName(theToken.getUnit()));
        theBuilder.append("}");
        return theBuilder.toString();
    }

    private String formatFieldValueOperand(FieldValueOperand aToken) {
        StringBuilder theBuilder = new StringBuilder();
        theBuilder.append("@");
        theBuilder.append(ExpressionParser.escapeFieldName(aToken.getFieldName()));
        theBuilder.append("@");
        theBuilder.append(this.formatIndex(aToken.getKeyContainer(), aToken.getFieldName()));
        return theBuilder.toString();
    }

    private String formatIndex(FieldIndexKeyContainer anIndex, String aFieldName) {
        if (anIndex == null) {
            return "";
        }
        StringBuilder theBuilder = new StringBuilder();
        FieldDefinition parentField = this.myRepository.getFieldDefinitionByName(aFieldName);
        String[] keyFieldNames = parentField.getKeyFields();
        Object[] rawKeys = anIndex.getRawKeys();
        if (parentField.isArray() || parentField.isMap() && keyFieldNames.length == 0) {
            assert (rawKeys.length == 1);
            Object obj = this.getObjectFromRawKey(rawKeys, 0);
            DataType resolver = parentField.isArray() ? DataType.INTEGER : DataType.STRING;
            this.appendSingleKeySpec(theBuilder, obj, resolver);
        } else {
            assert (rawKeys.length == keyFieldNames.length);
            for (int i = 0; i < keyFieldNames.length; ++i) {
                if (i > 0) {
                    theBuilder.append(";");
                }
                FieldDefinition keyField = this.myRepository.getFieldDefinitionByName(keyFieldNames[i]);
                Object obj = this.getObjectFromRawKey(rawKeys, i);
                ValueResolver resolver = FieldDefinitionUtil.createValueResolver(this.myRepository, keyField);
                this.appendSingleKeySpec(theBuilder, obj, resolver);
            }
        }
        String str = theBuilder.toString();
        return "[" + ExpressionParser.escapeIndexSpec(str) + "]";
    }

    private void appendSingleKeySpec(StringBuilder builder, Object obj, ValueResolver resolver) {
        char marker;
        String str;
        if (FieldIndexKeyContainer.rawKeyRepresentsField(obj)) {
            DataSetField field = FieldIndexKeyContainer.getFieldFromRawKey(obj);
            str = field.getFieldName();
            marker = '#';
        } else {
            marker = '$';
            str = resolver.makeValueString(obj);
        }
        builder.append(marker);
        builder.append(this.escapeKeyValue(str));
    }

    private Object getObjectFromRawKey(Object[] rawKeys, int index) {
        Object o = rawKeys[index];
        if (o instanceof Key) {
            Key k = (Key)o;
            o = k.containsKey() ? k.getKey() : Integer.valueOf(k.getIndex());
        }
        return o;
    }

    private String escapeKeyValue(String value) {
        String escaped = value.replace(";", "\\;");
        return escaped;
    }

    private String formatLiteral(String aValue, DataType aType) {
        boolean isString = aType != null && aType.isStringType();
        StringBuilder returnString = new StringBuilder();
        if (isString) {
            returnString.append(StringUtil.quote(ExpressionParser.escapeString(aValue)));
        } else {
            returnString.append(aValue);
        }
        if (aType != null) {
            returnString.append((char)(65 + aType.getTypeIdentifier()));
        }
        return returnString.toString();
    }

    private String formatValueOperand(ValueOperand<?> theToken) {
        Object value = theToken.getValue(null);
        DataType theType = DataType.fromObjectClass(value);
        return this.formatLiteral(theType.makeValueString(value), theType);
    }
}

