/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffProgressDialog;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import ericsson.ere.gui.ratingrules.RatingJTreeErrorHandler;
import ericsson.ere.gui.ratingrules.RatingJTreeNodeFactory;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.xml.XMLUtil;
import javax.swing.SwingWorker;
import org.w3c.dom.Element;

class BuildTariffStructureWorker
extends SwingWorker<TSTariffStructure, Void> {
    private RatingRuleBuilder myBuilder;
    private DiffProgressDialog myDialog;
    private RatingPeriodProxy myPeriod;

    BuildTariffStructureWorker(DiffProgressDialog progressDialog, ContextAwareServiceContainer serviceContainer, RatingPeriodProxy period) {
        RatingJTreeNodeFactory nodeFactory = new RatingJTreeNodeFactory(serviceContainer.getService().getId(), serviceContainer.getClassRepository());
        RatingJTreeErrorHandler errorHandler = new RatingJTreeErrorHandler();
        this.myBuilder = new RatingRuleBuilder(nodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        this.myDialog = progressDialog;
        this.myPeriod = period;
    }

    @Override
    protected TSTariffStructure doInBackground() throws Exception {
        TSTariffStructure structure;
        Element ratingRuleTree = this.myPeriod.getRatingPeriodRuleTree();
        if ("TariffStructure".equals(ratingRuleTree.getNodeName())) {
            structure = (TSTariffStructure)this.myBuilder.build(ratingRuleTree);
        } else {
            Element ratingRuleTreeElement = (Element)XMLUtil.getNamedElement("TariffStructure", ratingRuleTree.getElementsByTagName("TariffStructure")).getParentNode();
            structure = (TSTariffStructure)this.myBuilder.build(ratingRuleTreeElement.getNodeName(), ratingRuleTreeElement.getChildNodes(), null);
        }
        return structure;
    }

    @Override
    public void done() {
        this.myDialog.setVisible(false);
        this.myDialog.dispose();
    }
}

