/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffPoint;
import com.ericsson.ere.gui.diff.DiffToolPanel;
import com.ericsson.ere.gui.diff.DiffTree;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TariffCellRenderer;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import java.awt.Component;
import java.awt.Image;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;

public class DiffTreeCellRenderer
extends TariffCellRenderer {
    private Image structure_diff;
    private Image structure_multi;
    private Image structure_sub;
    private Image folder_diff;
    private Image folder_multi;
    private Image folder_sub;
    private Image folder_expanded_diff;
    private Image folder_expanded_multi;
    private Image folder_expanded_sub;
    private Image condition_diff;
    private Image condition_multi;
    private Image condition_sub;
    private Image modifier_diff;
    private Image modifier_multi;
    private Image folder_link_diff;
    private Image condition_link_diff;
    private Image modifier_link_diff;
    private Image defs_diff;
    private Image defs_multi;
    private Image defs_sub;
    private Image[][] diffIcons;
    private static final int DIFF_TYPE_DIFF = 0;
    private static final int DIFF_TYPE_MULTI = 1;
    private static final int DIFF_TYPE_SUB = 2;

    public DiffTreeCellRenderer() {
        this.initIcons();
    }

    private void initIcons() {
        this.structure_diff = RmaDefs.getImageIcon("structure_diff16.png").getImage();
        this.structure_multi = RmaDefs.getImageIcon("structure_multi16.png").getImage();
        this.structure_sub = RmaDefs.getImageIcon("structure_sub16.png").getImage();
        this.folder_diff = RmaDefs.getImageIcon("folder_diff16.png").getImage();
        this.folder_multi = RmaDefs.getImageIcon("folder_multi16.png").getImage();
        this.folder_sub = RmaDefs.getImageIcon("folder_sub16.png").getImage();
        this.folder_expanded_diff = RmaDefs.getImageIcon("folder_expanded_diff16.png").getImage();
        this.folder_expanded_multi = RmaDefs.getImageIcon("folder_expanded_multi16.png").getImage();
        this.folder_expanded_sub = RmaDefs.getImageIcon("folder_expanded_sub16.png").getImage();
        this.condition_diff = RmaDefs.getImageIcon("condition_diff16.png").getImage();
        this.condition_multi = RmaDefs.getImageIcon("condition_multi16.png").getImage();
        this.condition_sub = RmaDefs.getImageIcon("condition_sub16.png").getImage();
        this.modifier_diff = RmaDefs.getImageIcon("modifier_diff16.png").getImage();
        this.modifier_multi = RmaDefs.getImageIcon("modifier_multi16.png").getImage();
        this.folder_link_diff = RmaDefs.getImageIcon("folder_link_diff16.png").getImage();
        this.condition_link_diff = RmaDefs.getImageIcon("condition_link_diff16.png").getImage();
        this.modifier_link_diff = RmaDefs.getImageIcon("modifier_link_diff16.png").getImage();
        this.defs_diff = RmaDefs.getImageIcon("defs_diff16.png").getImage();
        this.defs_multi = RmaDefs.getImageIcon("defs_multi16.png").getImage();
        this.defs_sub = RmaDefs.getImageIcon("defs_sub16.png").getImage();
        this.diffIcons = new Image[6][6];
        this.diffIcons[0][0] = this.structure_diff;
        this.diffIcons[0][1] = this.structure_multi;
        this.diffIcons[0][2] = this.structure_sub;
        this.diffIcons[0][3] = this.structure_diff;
        this.diffIcons[0][4] = this.structure_multi;
        this.diffIcons[0][5] = this.structure_sub;
        this.diffIcons[1][0] = this.folder_diff;
        this.diffIcons[1][1] = this.folder_multi;
        this.diffIcons[1][2] = this.folder_sub;
        this.diffIcons[1][3] = this.folder_expanded_diff;
        this.diffIcons[1][4] = this.folder_expanded_multi;
        this.diffIcons[1][5] = this.folder_expanded_sub;
        this.diffIcons[2][0] = this.condition_diff;
        this.diffIcons[2][1] = this.condition_multi;
        this.diffIcons[2][2] = this.condition_sub;
        this.diffIcons[2][3] = this.condition_diff;
        this.diffIcons[2][4] = this.condition_multi;
        this.diffIcons[2][5] = this.condition_sub;
        this.diffIcons[3][0] = this.modifier_diff;
        this.diffIcons[3][1] = this.modifier_multi;
        this.diffIcons[4][1] = this.folder_link_diff;
        this.diffIcons[4][2] = this.condition_link_diff;
        this.diffIcons[4][3] = this.modifier_link_diff;
        this.diffIcons[5][0] = this.defs_diff;
        this.diffIcons[5][1] = this.defs_multi;
        this.diffIcons[5][2] = this.defs_sub;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean valueHasFocus) {
        JLabel nameLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, this.hasFocus);
        DiffToolPanel diffToolPanel = ((DiffTree)tree).getDiffToolPanel();
        TariffDAGNode node = (TariffDAGNode)value;
        List<DiffPoint> diffPoints = diffToolPanel.getAssociatedDiffPoints(node);
        DiffPoint diffPoint = null;
        if (diffPoints != null) {
            diffPoint = diffPoints.get(0);
            Icon diffIcon = diffPoints.size() > 1 ? this.getDiffIcon(node, 1, expanded) : this.getDiffIcon(node, 0, expanded);
            nameLabel.setForeground(diffPoint.getDiffColor());
            nameLabel.setIcon(diffIcon);
        } else if (diffToolPanel.hasDescendantDiffPoints(node)) {
            nameLabel.setIcon(this.getDiffIcon(node, 2, expanded));
        }
        return nameLabel;
    }

    @Override
    protected void updateForegroundIfNecessary(TariffDAGNode node) {
    }

    private Icon getDiffIcon(TariffDAGNode node, int diffType, boolean expanded) {
        Image ico = node instanceof TSLink ? this.diffIcons[DiffTree.getNodeType(node)][node.getNodeType()] : (node.getTypename().equals("Defs") ? this.diffIcons[DiffTree.getNodeType(node)][diffType] : this.diffIcons[DiffTree.getNodeType(node)][diffType + (expanded ? 3 : 0)]);
        return new ImageIcon(ico);
    }
}

