/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.propertyeditor;

import com.ericsson.ere.gui.editors.interfaces.ProxySettingsEditorInterface;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.InternalEreProxy;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.ere.integration.settingsmap.propertyio.VarTableOutput;
import ericsson.vareditor.VarTableModel;
import java.util.Vector;

public class DefaultEreProxySettingsEditor
implements ProxySettingsEditorInterface {
    @Override
    public void performEdit(AbstractEreProxy abstractProxy) {
        if (abstractProxy instanceof EreProxy) {
            final EreProxy ereProxy = (EreProxy)abstractProxy;
            VarTableModel oldSettings = null;
            if (ereProxy instanceof InternalEreProxy) {
                oldSettings = VarTableOutput.writeToVarTableModel(ereProxy.getSettingsMap());
            } else {
                SettingsMap showPropertiesSettingsMap = (SettingsMap)ereProxy.getSettingsMap().clone();
                showPropertiesSettingsMap.removeParameter("Password");
                oldSettings = VarTableOutput.writeToVarTableModel(showPropertiesSettingsMap);
            }
            PropertiesEditor.showDialogEdit(oldSettings, "Properties for '" + abstractProxy.toString() + "'", new EditablePropertiesInterface(){

                @Override
                public void cancel() {
                }

                @Override
                public String getTitle() {
                    return null;
                }

                @Override
                public void update(VarTableModel model) throws PropertiesException {
                    try {
                        SettingsMap finalSettings = VarTableInput.readFromVarTableModel(model);
                        DefaultEreProxySettingsEditor.this.validateSettings(finalSettings, ereProxy);
                        ereProxy.setSettingsMap(finalSettings);
                    }
                    catch (PropertiesException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        ExceptionUtil.handleException(e, "navigator", 2, "Failed to set new properties for the Service", true);
                    }
                }

                @Override
                public boolean isSuccessful() {
                    return true;
                }
            });
        }
    }

    private void validateSettings(SettingsMap settings, EreProxy proxy) throws PropertiesException {
        this.validateSettings(settings);
        DefaultEreProxySettingsEditor.validateNodeName(settings, proxy);
    }

    protected void validateSettings(SettingsMap settings) throws PropertiesException {
    }

    public static void validateNodeName(SettingsMap settings, EreProxy ownEreProxy) throws PropertiesException {
        String name = settings.getParameter("Name").getValue();
        if (name.isEmpty()) {
            throw new PropertiesException("Name must be specified.");
        }
        Vector<EreProxy> eres = EreProxyManager.getInstance().getRemoteEreList();
        for (EreProxy ere : eres) {
            String nodeName;
            if (ere.equals(ownEreProxy) || !(nodeName = ere.getName()).equalsIgnoreCase(name) && !name.equalsIgnoreCase("Internal Ere")) continue;
            throw new PropertiesException("The ERE node name " + name + " is not unique within the ERE Navigator.");
        }
    }
}

