/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ServiceEditorTreeRenderer
extends DefaultTreeCellRenderer {
    private static final Color NONFOCUS_SELECTION_COLOR = new Color(240, 240, 240);

    @Override
    public Color getBackgroundSelectionColor() {
        Color bgColor = !this.hasFocus && this.selected ? NONFOCUS_SELECTION_COLOR : super.getBackgroundSelectionColor();
        return bgColor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
        if (value instanceof AbstractTreeNode) {
            boolean isValid;
            AbstractTreeNode node = (AbstractTreeNode)value;
            String text = node.toString();
            if (this.isDraggingOverRow(tree, row)) {
                text = "<html><u>" + text + "</u>";
            }
            this.setText(text);
            ImageIcon icon = node.getNodeIcon(tree);
            if (icon != null) {
                this.setIcon(icon);
            }
            Color fgColor = (isValid = node.isNodeValid()) ? Color.BLACK : Color.RED;
            this.setForeground(fgColor);
            if (isValid) {
                this.setToolTipText(node.getToolTipText());
            } else {
                String reason = node.getInvalidReason();
                this.setToolTipText(reason.length() > 0 ? reason : null);
            }
        }
        return this;
    }

    private boolean isDraggingOverRow(JTree tree, int row) {
        JTree.DropLocation dropLocation = tree.getDropLocation();
        return dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row;
    }
}

